/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.util.TreePath;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.ProcessInstanceCoreStatisticsDto;
import io.camunda.operate.webapp.rest.dto.ProcessInstanceReferenceDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewProcessInstanceDto;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceReader.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private ProcessStore processStore;
    @Autowired
    private OperationReader operationReader;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    public ListViewProcessInstanceDto getProcessInstanceWithOperationsByKey(Long processInstanceKey) {
        ProcessInstanceForListViewEntity processInstance = this.processStore.getProcessInstanceListViewByKey(processInstanceKey);
        List callHierarchy = this.createCallHierarchy(processInstance.getTreePath(), String.valueOf(processInstanceKey));
        return ListViewProcessInstanceDto.createFrom((ProcessInstanceForListViewEntity)processInstance, (List)this.operationReader.getOperationsByProcessInstanceKey(processInstanceKey), (List)callHierarchy, (PermissionsService)this.permissionsService, (ObjectMapper)this.objectMapper);
    }

    private List<ProcessInstanceReferenceDto> createCallHierarchy(String treePath, String currentProcessInstanceId) {
        ArrayList callHierarchy = new ArrayList();
        List processInstanceIds = new TreePath(treePath).extractProcessInstanceIds();
        return this.processStore.createCallHierarchyFor(processInstanceIds, currentProcessInstanceId).stream().map(r -> new ProcessInstanceReferenceDto().setInstanceId(String.valueOf(r.get("instanceId"))).setProcessDefinitionId((String)r.get("processDefinitionId")).setProcessDefinitionName((String)r.get("processDefinitionName"))).sorted(Comparator.comparing(ref -> processInstanceIds.indexOf(ref.getInstanceId()))).toList();
    }

    public ProcessInstanceForListViewEntity getProcessInstanceByKey(Long processInstanceKey) {
        return this.processStore.getProcessInstanceListViewByKey(processInstanceKey);
    }

    public ProcessInstanceCoreStatisticsDto getCoreStatistics() {
        PermissionsService.ResourcesAllowed allowed;
        Map statistics = this.permissionsService != null ? this.processStore.getCoreStatistics((allowed = this.permissionsService.getProcessesWithPermission(IdentityPermission.READ)) == null || allowed.isAll() ? null : allowed.getIds()) : this.processStore.getCoreStatistics(null);
        Long runningCount = (Long)statistics.get("running");
        Long incidentCount = (Long)statistics.get("incidents");
        ProcessInstanceCoreStatisticsDto processInstanceCoreStatisticsDto = new ProcessInstanceCoreStatisticsDto().setRunning(runningCount).setActive(Long.valueOf(runningCount - incidentCount)).setWithIncidents(incidentCount);
        return processInstanceCoreStatisticsDto;
    }

    public String getProcessInstanceTreePath(String processInstanceId) {
        return this.processStore.getProcessInstanceTreePathById(processInstanceId);
    }
}

