/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.webapp.elasticsearch.QueryHelper;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.listview.ListViewProcessInstanceDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewRequestDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewResponseDto;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ListViewReader
implements io.camunda.operate.webapp.reader.ListViewReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListViewReader.class);
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private OperationReader operationReader;
    @Autowired
    private QueryHelper queryHelper;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    public ListViewResponseDto queryProcessInstances(ListViewRequestDto processInstanceRequest) {
        ListViewResponseDto result = new ListViewResponseDto();
        List processInstanceEntities = this.queryListView(processInstanceRequest, result);
        List processInstanceKeys = CollectionUtil.map((Collection)processInstanceEntities, processInstanceEntity -> Long.valueOf(processInstanceEntity.getId()));
        Map operationsPerProcessInstance = this.operationReader.getOperationsPerProcessInstanceKey(processInstanceKeys);
        List processInstanceDtoList = ListViewProcessInstanceDto.createFrom((List)processInstanceEntities, (Map)operationsPerProcessInstance, (ObjectMapper)this.objectMapper);
        result.setProcessInstances(processInstanceDtoList);
        return result;
    }

    public List<ProcessInstanceForListViewEntity> queryListView(ListViewRequestDto processInstanceRequest, ListViewResponseDto result) {
        QueryBuilder query = this.queryHelper.createRequestQuery(processInstanceRequest.getQuery());
        LOGGER.debug("Process instance search request: \n{}", (Object)query.toString());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query);
        this.applySorting(searchSourceBuilder, processInstanceRequest);
        SearchRequest searchRequest = this.queryHelper.createSearchRequest(processInstanceRequest.getQuery()).source(searchSourceBuilder);
        LOGGER.debug("Search request will search in: \n{}", (Object[])searchRequest.indices());
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            result.setTotalCount(response.getHits().getTotalHits().value);
            List processInstanceEntities = ElasticsearchUtil.mapSearchHits((SearchHit[])response.getHits().getHits(), sh -> {
                ProcessInstanceForListViewEntity entity = (ProcessInstanceForListViewEntity)ElasticsearchUtil.fromSearchHit((String)sh.getSourceAsString(), (ObjectMapper)this.objectMapper, ProcessInstanceForListViewEntity.class);
                entity.setSortValues(sh.getSortValues());
                return entity;
            });
            if (processInstanceRequest.getSearchBefore() != null) {
                Collections.reverse(processInstanceEntities);
            }
            return processInstanceEntities;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining instances list: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    public Tuple<String, String> getCalledProcessInstanceIdAndNameByFlowNodeInstanceId(String flowNodeInstanceId) {
        String[] calledProcessInstanceId = new String[]{null};
        String[] calledProcessDefinitionName = new String[]{null};
        this.findCalledProcessInstance(flowNodeInstanceId, sh -> {
            calledProcessInstanceId[0] = sh.getId();
            Map source = sh.getSourceAsMap();
            String processName = (String)source.get("processName");
            if (processName == null) {
                processName = (String)source.get("bpmnProcessId");
            }
            calledProcessDefinitionName[0] = processName;
        });
        return Tuple.of((Object)calledProcessInstanceId[0], (Object)calledProcessDefinitionName[0]);
    }

    private void applySorting(SearchSourceBuilder searchSourceBuilder, ListViewRequestDto request) {
        Object[] querySearchAfter;
        SortBuilder sort2;
        boolean directSorting;
        String sortBy = this.getSortBy(request);
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchBefore() == null;
        if (request.getSorting() != null) {
            SortOrder sort1DirectOrder = SortOrder.fromString((String)request.getSorting().getSortOrder());
            FieldSortBuilder sort1 = directSorting ? ((FieldSortBuilder)SortBuilders.fieldSort((String)sortBy).order(sort1DirectOrder)).missing((Object)"_last") : ((FieldSortBuilder)SortBuilders.fieldSort((String)sortBy).order(this.reverseOrder(sort1DirectOrder))).missing((Object)"_first");
            searchSourceBuilder.sort((SortBuilder)sort1);
        }
        if (directSorting) {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.ASC);
            querySearchAfter = request.getSearchAfter(this.objectMapper);
        } else {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.DESC);
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        }
        searchSourceBuilder.sort(sort2).size(request.getPageSize().intValue());
        if (querySearchAfter != null) {
            searchSourceBuilder.searchAfter(querySearchAfter);
        }
    }

    private String getSortBy(ListViewRequestDto request) {
        if (request.getSorting() != null) {
            String sortBy = request.getSorting().getSortBy();
            if (sortBy.equals("parentInstanceId")) {
                sortBy = "parentProcessInstanceKey";
            } else if (sortBy.equals("tenant")) {
                sortBy = "tenantId";
            }
            if (sortBy.equals("id")) {
                sortBy = "key";
            }
            return sortBy;
        }
        return null;
    }

    private SortOrder reverseOrder(SortOrder sortOrder) {
        if (sortOrder.equals((Object)SortOrder.ASC)) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }

    private void findCalledProcessInstance(String flowNodeInstanceId, Consumer<SearchHit> processInstanceConsumer) {
        TermQueryBuilder parentFlowNodeInstanceQ = QueryBuilders.termQuery((String)"parentFlowNodeInstanceKey", (String)flowNodeInstanceId);
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.listViewTemplate).source(new SearchSourceBuilder().query((QueryBuilder)parentFlowNodeInstanceQ).fetchSource(new String[]{"processName", "bpmnProcessId"}, null));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value >= 1L) {
                processInstanceConsumer.accept(response.getHits().getAt(0));
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining parent process instance id for flow node instance: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

