/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.UserTaskEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.schema.templates.UserTaskTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.reader.UserTaskReader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchUserTaskReader
extends AbstractReader
implements UserTaskReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUserTaskReader.class);
    private final UserTaskTemplate userTaskTemplate;

    public ElasticsearchUserTaskReader(UserTaskTemplate userTaskTemplate) {
        this.userTaskTemplate = userTaskTemplate;
    }

    public List<UserTaskEntity> getUserTasks() {
        LOGGER.debug("retrieve all user tasks");
        try {
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.userTaskTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ALL).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
            return this.scroll(searchRequest, UserTaskEntity.class);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining user task list: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    public Optional<UserTaskEntity> getUserTaskByFlowNodeInstanceKey(long flowNodeInstanceKey) {
        LOGGER.debug("Get UserTask by flowNodeInstanceKey {}", (Object)flowNodeInstanceKey);
        try {
            TermQueryBuilder query = QueryBuilders.termQuery((String)"elementInstanceKey", (long)flowNodeInstanceKey);
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.userTaskTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ALL).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
            SearchHits hits = this.tenantAwareClient.search(searchRequest).getHits();
            if (hits.getTotalHits().value == 1L) {
                return Optional.of((UserTaskEntity)ElasticsearchUtil.mapSearchHits((SearchHit[])hits.getHits(), (ObjectMapper)this.objectMapper, UserTaskEntity.class).get(0));
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining user task list: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return Optional.empty();
    }
}

