/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.elasticsearch.QueryHelper;
import io.camunda.operate.webapp.elasticsearch.reader.ElasticsearchFlowNodeStatisticsReader;
import io.camunda.operate.webapp.reader.FlowNodeStatisticsReader;
import io.camunda.operate.webapp.rest.dto.FlowNodeStatisticsDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.aggregations.Children;
import org.elasticsearch.join.aggregations.ChildrenAggregationBuilder;
import org.elasticsearch.join.aggregations.JoinAggregationBuilders;
import org.elasticsearch.join.aggregations.Parent;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchFlowNodeStatisticsReader
implements FlowNodeStatisticsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchFlowNodeStatisticsReader.class);
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private QueryHelper queryHelper;

    public Collection<FlowNodeStatisticsDto> getFlowNodeStatistics(ListViewQueryDto query) {
        SearchRequest searchRequest = !query.isFinished() ? this.createQuery(query, ElasticsearchUtil.QueryType.ONLY_RUNTIME) : this.createQuery(query, ElasticsearchUtil.QueryType.ALL);
        Map statisticsMap = this.runQueryAndCollectStats(searchRequest);
        return statisticsMap.values();
    }

    private Map<String, FlowNodeStatisticsDto> runQueryAndCollectStats(SearchRequest searchRequest) {
        try {
            HashMap<String, FlowNodeStatisticsDto> statisticsMap = new HashMap<String, FlowNodeStatisticsDto>();
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            if (searchResponse.getAggregations() != null) {
                Children activities = (Children)searchResponse.getAggregations().get("activities");
                CollectionUtil.asMap((Object[])new Object[]{"active_activities", FlowNodeStatisticsDto::addActive, "incident_activities", FlowNodeStatisticsDto::addIncidents, "terminated_activities", FlowNodeStatisticsDto::addCanceled, "finished_activities", FlowNodeStatisticsDto::addCompleted}).forEach((aggName, mapUpdater) -> this.collectStatisticsFor(statisticsMap, activities, aggName, (MapUpdater)mapUpdater));
            }
            return statisticsMap;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining statistics for activities: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private SearchRequest createQuery(ListViewQueryDto query, ElasticsearchUtil.QueryType queryType) {
        ConstantScoreQueryBuilder q = QueryBuilders.constantScoreQuery((QueryBuilder)this.queryHelper.createQueryFragment(query));
        ChildrenAggregationBuilder agg = JoinAggregationBuilders.children((String)"activities", (String)"activity");
        if (query.isActive()) {
            agg = (ChildrenAggregationBuilder)agg.subAggregation((AggregationBuilder)this.getActiveFlowNodesAgg());
        }
        if (query.isCanceled()) {
            agg = (ChildrenAggregationBuilder)agg.subAggregation((AggregationBuilder)this.getTerminatedActivitiesAgg());
        }
        if (query.isIncidents()) {
            agg = (ChildrenAggregationBuilder)agg.subAggregation((AggregationBuilder)this.getIncidentActivitiesAgg());
        }
        agg = (ChildrenAggregationBuilder)agg.subAggregation((AggregationBuilder)this.getFinishedActivitiesAgg());
        LOGGER.debug("Activities statistics request: \n{}\n and aggregation: \n{}", (Object)q, (Object)agg);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.listViewTemplate, (ElasticsearchUtil.QueryType)queryType);
        LOGGER.debug("Search request will search in: \n{}", (Object[])searchRequest.indices());
        return searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)q).size(0).aggregation((AggregationBuilder)agg));
    }

    private void collectStatisticsFor(Map<String, FlowNodeStatisticsDto> statisticsMap, Children activities, String aggName, MapUpdater mapUpdater) {
        Filter incidentActivitiesAgg = (Filter)activities.getAggregations().get(aggName);
        if (incidentActivitiesAgg != null) {
            ((Terms)incidentActivitiesAgg.getAggregations().get("unique_activities")).getBuckets().stream().forEach(b -> {
                String activityId = b.getKeyAsString();
                Parent aggregation = (Parent)b.getAggregations().get("activity_to_process");
                long docCount = aggregation.getDocCount();
                if (statisticsMap.get(activityId) == null) {
                    statisticsMap.put(activityId, new FlowNodeStatisticsDto(activityId));
                }
                mapUpdater.updateMapEntry((FlowNodeStatisticsDto)statisticsMap.get(activityId), Long.valueOf(docCount));
            });
        }
    }

    private FilterAggregationBuilder getTerminatedActivitiesAgg() {
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)"terminated_activities", (QueryBuilder)QueryBuilders.termQuery((String)"activityState", (Object)FlowNodeState.TERMINATED)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"unique_activities").field("activityId")).size(10000).subAggregation((AggregationBuilder)JoinAggregationBuilders.parent((String)"activity_to_process", (String)"activity")));
    }

    private FilterAggregationBuilder getActiveFlowNodesAgg() {
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)"active_activities", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)false)).must((QueryBuilder)QueryBuilders.termQuery((String)"activityState", (String)FlowNodeState.ACTIVE.toString()))).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"unique_activities").field("activityId")).size(10000).subAggregation((AggregationBuilder)JoinAggregationBuilders.parent((String)"activity_to_process", (String)"activity")));
    }

    private FilterAggregationBuilder getIncidentActivitiesAgg() {
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)"incident_activities", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)true)).must((QueryBuilder)QueryBuilders.termQuery((String)"activityState", (String)FlowNodeState.ACTIVE.toString()))).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"unique_activities").field("activityId")).size(10000).subAggregation((AggregationBuilder)JoinAggregationBuilders.parent((String)"activity_to_process", (String)"activity")));
    }

    private FilterAggregationBuilder getFinishedActivitiesAgg() {
        QueryBuilder completedEndEventsQ = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"activityType", (String)FlowNodeType.END_EVENT.toString()), QueryBuilders.termQuery((String)"activityState", (String)FlowNodeState.COMPLETED.toString())});
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)"finished_activities", (QueryBuilder)completedEndEventsQ).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"unique_activities").field("activityId")).size(10000).subAggregation((AggregationBuilder)JoinAggregationBuilders.parent((String)"activity_to_process", (String)"activity")));
    }
}

