/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.dmn.DecisionInstanceEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.dmn.DRDDataEntryDto;
import io.camunda.operate.webapp.rest.dto.dmn.DecisionInstanceDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceForListDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListQueryDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListRequestDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListResponseDto;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class DecisionInstanceReader
extends AbstractReader
implements io.camunda.operate.webapp.reader.DecisionInstanceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionInstanceReader.class);
    @Autowired(required=false)
    protected PermissionsService permissionsService;
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private OperateProperties operateProperties;

    public DecisionInstanceDto getDecisionInstance(String decisionInstanceId) {
        QueryBuilder query = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.idsQuery().addIds(new String[]{String.valueOf(decisionInstanceId)}), QueryBuilders.termQuery((String)"id", (String)decisionInstanceId)});
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.decisionInstanceTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ALL).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value == 1L) {
                DecisionInstanceEntity decisionInstance = (DecisionInstanceEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getHits()[0].getSourceAsString(), (ObjectMapper)this.objectMapper, DecisionInstanceEntity.class);
                return (DecisionInstanceDto)DtoCreator.create((Object)decisionInstance, DecisionInstanceDto.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique decision instance with id '%s'.", decisionInstanceId));
            }
            throw new NotFoundException(String.format("Could not find decision instance with id '%s'.", decisionInstanceId));
        }
        catch (IOException ex) {
            throw new OperateRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }

    public DecisionInstanceListResponseDto queryDecisionInstances(DecisionInstanceListRequestDto request) {
        DecisionInstanceListResponseDto result = new DecisionInstanceListResponseDto();
        List entities = this.queryDecisionInstancesEntities(request, result);
        result.setDecisionInstances(DecisionInstanceForListDto.createFrom((List)entities, (ObjectMapper)this.objectMapper));
        return result;
    }

    public Map<String, List<DRDDataEntryDto>> getDecisionInstanceDRDData(String decisionInstanceId) {
        Long decisionInstanceKey = DecisionInstanceEntity.extractKey((String)decisionInstanceId);
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.decisionInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)decisionInstanceKey)).fetchSource(new String[]{"decisionId", "state"}, null).sort("evaluationDate", SortOrder.ASC));
        try {
            List entries = (List)this.tenantAwareClient.search(request, () -> ElasticsearchUtil.scroll((SearchRequest)request, DRDDataEntryDto.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient, sh -> {
                Map map = sh.getSourceAsMap();
                return new DRDDataEntryDto(sh.getId(), (String)map.get("decisionId"), DecisionInstanceState.valueOf((String)((String)map.get("state"))));
            }, null, null));
            return entries.stream().collect(Collectors.groupingBy(DRDDataEntryDto::getDecisionId));
        }
        catch (IOException e) {
            throw new OperateRuntimeException("Exception occurred while quiering DRD data for decision instance id: " + decisionInstanceId);
        }
    }

    public Tuple<String, String> getCalledDecisionInstanceAndDefinitionByFlowNodeInstanceId(String flowNodeInstanceId) {
        String[] calledDecisionInstanceId = new String[]{null};
        String[] calledDecisionDefinitionName = new String[]{null};
        this.findCalledDecisionInstance(flowNodeInstanceId, sh -> {
            String decisionDefId;
            Map source = sh.getSourceAsMap();
            String rootDecisionDefId = (String)source.get("rootDecisionDefinitionId");
            if (rootDecisionDefId.equals(decisionDefId = (String)source.get("decisionDefinitionId"))) {
                calledDecisionInstanceId[0] = sh.getId();
                String decisionName = (String)source.get("decisionName");
                if (decisionName == null) {
                    decisionName = (String)source.get("decisionId");
                }
                calledDecisionDefinitionName[0] = decisionName;
            } else {
                String decisionName = (String)source.get("rootDecisionName");
                if (decisionName == null) {
                    decisionName = (String)source.get("rootDecisionId");
                }
                calledDecisionDefinitionName[0] = decisionName;
            }
        });
        return Tuple.of((Object)calledDecisionInstanceId[0], (Object)calledDecisionDefinitionName[0]);
    }

    private List<DecisionInstanceEntity> queryDecisionInstancesEntities(DecisionInstanceListRequestDto request, DecisionInstanceListResponseDto result) {
        QueryBuilder query = this.createRequestQuery(request.getQuery());
        LOGGER.debug("Decision instance search request: \n{}", (Object)query.toString());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).fetchSource(null, new String[]{"result", "evaluatedInputs", "evaluatedOutputs"});
        this.applySorting(searchSourceBuilder, request);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.decisionInstanceTemplate).source(searchSourceBuilder);
        LOGGER.debug("Search request will search in: \n{}", (Object[])searchRequest.indices());
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            result.setTotalCount(response.getHits().getTotalHits().value);
            List decisionInstanceEntities = ElasticsearchUtil.mapSearchHits((SearchHit[])response.getHits().getHits(), sh -> {
                DecisionInstanceEntity entity = (DecisionInstanceEntity)ElasticsearchUtil.fromSearchHit((String)sh.getSourceAsString(), (ObjectMapper)this.objectMapper, DecisionInstanceEntity.class);
                entity.setSortValues(sh.getSortValues());
                return entity;
            });
            if (request.getSearchBefore() != null) {
                Collections.reverse(decisionInstanceEntities);
            }
            return decisionInstanceEntities;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining instances list: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private void applySorting(SearchSourceBuilder searchSourceBuilder, DecisionInstanceListRequestDto request) {
        Object[] querySearchAfter;
        SortBuilder sort3;
        SortBuilder sort2;
        boolean directSorting;
        String sortBy = this.getSortBy(request);
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchBefore() == null;
        if (request.getSorting() != null) {
            SortOrder sort1DirectOrder = SortOrder.fromString((String)request.getSorting().getSortOrder());
            FieldSortBuilder sort1 = directSorting ? ((FieldSortBuilder)SortBuilders.fieldSort((String)sortBy).order(sort1DirectOrder)).missing((Object)"_last") : ((FieldSortBuilder)SortBuilders.fieldSort((String)sortBy).order(this.reverseOrder(sort1DirectOrder))).missing((Object)"_first");
            searchSourceBuilder.sort((SortBuilder)sort1);
        }
        if (directSorting) {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.ASC);
            sort3 = SortBuilders.fieldSort((String)"executionIndex").order(SortOrder.ASC);
            querySearchAfter = request.getSearchAfter(this.objectMapper);
        } else {
            sort2 = SortBuilders.fieldSort((String)"key").order(SortOrder.DESC);
            sort3 = SortBuilders.fieldSort((String)"executionIndex").order(SortOrder.DESC);
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        }
        searchSourceBuilder.sort(sort2).sort(sort3).size(request.getPageSize().intValue());
        if (querySearchAfter != null) {
            searchSourceBuilder.searchAfter(querySearchAfter);
        }
    }

    private String getSortBy(DecisionInstanceListRequestDto request) {
        if (request.getSorting() != null) {
            String sortBy = request.getSorting().getSortBy();
            if (sortBy.equals("id")) {
                sortBy = "key";
            } else if (sortBy.equals("tenant")) {
                sortBy = "tenantId";
            } else if (sortBy.equals("processInstanceId")) {
                sortBy = "processInstanceKey";
            }
            return sortBy;
        }
        return null;
    }

    private SortOrder reverseOrder(SortOrder sortOrder) {
        if (sortOrder.equals((Object)SortOrder.ASC)) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }

    private QueryBuilder createRequestQuery(DecisionInstanceListQueryDto query) {
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{this.createEvaluatedFailedQuery(query), this.createDecisionDefinitionIdsQuery(query), this.createIdsQuery(query), this.createProcessInstanceIdQuery(query), this.createEvaluationDateQuery(query), this.createReadPermissionQuery(), this.createTenantIdQuery(query)});
        if (queryBuilder == null) {
            queryBuilder = QueryBuilders.matchAllQuery();
        }
        return queryBuilder;
    }

    private QueryBuilder createTenantIdQuery(DecisionInstanceListQueryDto query) {
        if (query.getTenantId() != null) {
            return QueryBuilders.termQuery((String)"tenantId", (String)query.getTenantId());
        }
        return null;
    }

    private QueryBuilder createReadPermissionQuery() {
        if (this.permissionsService == null) {
            return null;
        }
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getDecisionsWithPermission(IdentityPermission.READ);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryBuilders.matchAllQuery() : QueryBuilders.termsQuery((String)"decisionId", (Collection)allowed.getIds());
    }

    private QueryBuilder createEvaluationDateQuery(DecisionInstanceListQueryDto query) {
        if (query.getEvaluationDateAfter() != null || query.getEvaluationDateBefore() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"evaluationDate");
            if (query.getEvaluationDateAfter() != null) {
                rangeQueryBuilder.gte((Object)this.dateTimeFormatter.format(query.getEvaluationDateAfter()));
            }
            if (query.getEvaluationDateBefore() != null) {
                rangeQueryBuilder.lt((Object)this.dateTimeFormatter.format(query.getEvaluationDateBefore()));
            }
            rangeQueryBuilder.format(this.operateProperties.getElasticsearch().getElsDateFormat());
            return rangeQueryBuilder;
        }
        return null;
    }

    private QueryBuilder createProcessInstanceIdQuery(DecisionInstanceListQueryDto query) {
        if (query.getProcessInstanceId() != null) {
            return QueryBuilders.termQuery((String)"processInstanceKey", (String)query.getProcessInstanceId());
        }
        return null;
    }

    private QueryBuilder createIdsQuery(DecisionInstanceListQueryDto query) {
        if (CollectionUtil.isNotEmpty((Collection)query.getIds())) {
            return QueryBuilders.termsQuery((String)"id", (Collection)query.getIds());
        }
        return null;
    }

    private QueryBuilder createDecisionDefinitionIdsQuery(DecisionInstanceListQueryDto query) {
        if (CollectionUtil.isNotEmpty((Collection)query.getDecisionDefinitionIds())) {
            return QueryBuilders.termsQuery((String)"decisionDefinitionId", (Collection)query.getDecisionDefinitionIds());
        }
        return null;
    }

    private QueryBuilder createEvaluatedFailedQuery(DecisionInstanceListQueryDto query) {
        if (query.isEvaluated() && query.isFailed()) {
            return null;
        }
        if (query.isFailed()) {
            return QueryBuilders.termQuery((String)"state", (Object)DecisionInstanceState.FAILED);
        }
        if (query.isEvaluated()) {
            return QueryBuilders.termQuery((String)"state", (Object)DecisionInstanceState.EVALUATED);
        }
        return ElasticsearchUtil.createMatchNoneQuery();
    }

    private void findCalledDecisionInstance(String flowNodeInstanceId, Consumer<SearchHit> decisionInstanceConsumer) {
        TermQueryBuilder flowNodeInstanceQ = QueryBuilders.termQuery((String)"elementInstanceKey", (String)flowNodeInstanceId);
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.decisionInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)flowNodeInstanceQ).fetchSource(new String[]{"rootDecisionDefinitionId", "rootDecisionName", "rootDecisionId", "decisionDefinitionId", "decisionName", "decisionId"}, null).sort("evaluationDate", SortOrder.DESC).sort("executionIndex", SortOrder.DESC));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value >= 1L) {
                decisionInstanceConsumer.accept(response.getHits().getAt(0));
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining calls decision instance id for flow node instance: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

