/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.indices.OperateWebSessionIndex;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.webapp.security.OperateSession;
import io.camunda.operate.webapp.security.SessionRepository;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchSessionRepository
implements SessionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSessionRepository.class);
    private final RetryElasticsearchClient retryElasticsearchClient;
    private final GenericConversionService conversionService;
    private final OperateWebSessionIndex operateWebSessionIndex;
    private final HttpServletRequest request;

    public ElasticsearchSessionRepository(RetryElasticsearchClient retryElasticsearchClient, GenericConversionService conversionService, OperateWebSessionIndex operateWebSessionIndex, HttpServletRequest request) {
        this.retryElasticsearchClient = retryElasticsearchClient;
        this.conversionService = conversionService;
        this.operateWebSessionIndex = operateWebSessionIndex;
        this.request = request;
    }

    @PostConstruct
    private void setUp() {
        this.setupConverter();
    }

    private void setupConverter() {
        this.conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        this.conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
    }

    public List<String> getExpiredSessionIds() {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.operateWebSessionIndex.getFullQualifiedName()});
        ArrayList<String> result = new ArrayList<String>();
        this.retryElasticsearchClient.doWithEachSearchResult(searchRequest, sh -> {
            Map document = sh.getSourceAsMap();
            Optional maybeSession = this.documentToSession(document);
            if (maybeSession.isPresent()) {
                OperateSession session = (OperateSession)maybeSession.get();
                LOGGER.debug("Check if session {} is expired: {}", (Object)session, (Object)session.isExpired());
                if (session.isExpired()) {
                    result.add(session.getId());
                }
            } else {
                result.add(this.getSessionIdFrom(document));
            }
        });
        return result;
    }

    public void save(OperateSession session) {
        this.retryElasticsearchClient.createOrUpdateDocument(this.operateWebSessionIndex.getFullQualifiedName(), session.getId(), this.sessionToDocument(session));
    }

    public Optional<OperateSession> findById(String id) {
        try {
            Optional<Map> maybeDocument = Optional.ofNullable(this.retryElasticsearchClient.getDocument(this.operateWebSessionIndex.getFullQualifiedName(), id));
            return maybeDocument.flatMap(arg_0 -> this.documentToSession(arg_0));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public void deleteById(String id) {
        this.retryElasticsearchClient.deleteDocument(this.operateWebSessionIndex.getFullQualifiedName(), id);
    }

    private byte[] serialize(Object object) {
        return (byte[])this.conversionService.convert(object, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class));
    }

    private Object deserialize(byte[] bytes) {
        return this.conversionService.convert((Object)bytes, TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    private Map<String, Object> sessionToDocument(OperateSession session) {
        HashMap attributes = new HashMap();
        session.getAttributeNames().forEach(name -> attributes.put(name, this.serialize(session.getAttribute(name))));
        return Map.of("id", session.getId(), "creationTime", session.getCreationTime().toEpochMilli(), "lastAccessedTime", session.getLastAccessedTime().toEpochMilli(), "maxInactiveIntervalInSeconds", session.getMaxInactiveInterval().getSeconds(), "attributes", attributes);
    }

    private String getSessionIdFrom(Map<String, Object> document) {
        return (String)document.get("id");
    }

    private Optional<OperateSession> documentToSession(Map<String, Object> document) {
        try {
            String sessionId = this.getSessionIdFrom(document);
            OperateSession session = new OperateSession(sessionId);
            session.setCreationTime(this.getInstantFor(document.get("creationTime")));
            session.setLastAccessedTime(this.getInstantFor(document.get("lastAccessedTime")));
            session.setMaxInactiveInterval(this.getDurationFor(document.get("maxInactiveIntervalInSeconds")));
            this.setPollingFor(session);
            Object attributesObject = document.get("attributes");
            if (attributesObject != null && attributesObject.getClass().isInstance(new HashMap())) {
                Map attributes = (Map)document.get("attributes");
                attributes.keySet().forEach(name -> session.setAttribute(name, this.deserialize(Base64.getDecoder().decode((String)attributes.get(name)))));
            }
            return Optional.of(session);
        }
        catch (Exception e) {
            LOGGER.error("Could not restore session.", (Throwable)e);
            return Optional.empty();
        }
    }

    private void setPollingFor(OperateSession session) {
        try {
            if (this.request != null && this.request.getHeader("x-is-polling") != null) {
                LOGGER.info("Set session polling to true");
                session.setPolling(true);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Expected Exception: is not possible to access request as currently this is not on a request context");
        }
    }

    private Instant getInstantFor(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            Long instantAsLong = (Long)object;
            return Instant.ofEpochMilli(instantAsLong);
        }
        return null;
    }

    private Duration getDurationFor(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            Integer durationAsInteger = (Integer)object;
            return Duration.ofSeconds(durationAsInteger.intValue());
        }
        return null;
    }
}

