/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.backup;

import io.camunda.operate.exceptions.OperateRuntimeException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class Metadata {
    public static final String SNAPSHOT_NAME_PREFIX = "camunda_operate_";
    private static final String SNAPSHOT_NAME_PATTERN = "{prefix}{version}_part_{index}_of_{count}";
    private static final String SNAPSHOT_NAME_PREFIX_PATTERN = "camunda_operate_{backupId}_";
    private static final Pattern BACKUPID_PATTERN = Pattern.compile("camunda_operate_(\\d*)_.*");
    private Long backupId;
    private String version;
    private Integer partNo;
    private Integer partCount;

    public static String buildSnapshotNamePrefix(Long backupId) {
        return "camunda_operate_{backupId}_".replace("{backupId}", String.valueOf(backupId));
    }

    public static Long extractBackupIdFromSnapshotName(String snapshotName) {
        Matcher matcher = BACKUPID_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            return Long.valueOf(matcher.group(1));
        }
        throw new OperateRuntimeException("Unable to extract backupId. Snapshot name: " + snapshotName);
    }

    public Long getBackupId() {
        return this.backupId;
    }

    public Metadata setBackupId(Long backupId) {
        this.backupId = backupId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Metadata setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getPartNo() {
        return this.partNo;
    }

    public Metadata setPartNo(Integer partNo) {
        this.partNo = partNo;
        return this;
    }

    public Integer getPartCount() {
        return this.partCount;
    }

    public Metadata setPartCount(Integer partCount) {
        this.partCount = partCount;
        return this;
    }

    public String buildSnapshotName() {
        return "{prefix}{version}_part_{index}_of_{count}".replace("{prefix}", Metadata.buildSnapshotNamePrefix((Long)this.backupId)).replace("{version}", this.version).replace("{index}", "" + this.partNo).replace("{count}", "" + this.partCount);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.partNo, this.partCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.partNo, that.partNo) && Objects.equals(this.partCount, that.partCount);
    }
}

