/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.backup;

import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.backup.Prio1Backup;
import io.camunda.operate.schema.backup.Prio2Backup;
import io.camunda.operate.schema.backup.Prio3Backup;
import io.camunda.operate.schema.backup.Prio4Backup;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.webapp.backup.BackupRepository;
import io.camunda.operate.webapp.backup.BackupService;
import io.camunda.operate.webapp.backup.Metadata;
import io.camunda.operate.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.operate.webapp.management.dto.TakeBackupRequestDto;
import io.camunda.operate.webapp.management.dto.TakeBackupResponseDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class BackupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupService.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final Queue<SnapshotRequest> requestsQueue = new ConcurrentLinkedQueue();
    private final List<Prio1Backup> prio1BackupIndices;
    private final List<Prio2Backup> prio2BackupTemplates;
    private final List<Prio3Backup> prio3BackupTemplates;
    private final List<Prio4Backup> prio4BackupIndices;
    private final OperateProperties operateProperties;
    private final BackupRepository repository;
    private String[][] indexPatternsOrdered;

    public BackupService(@Qualifier(value="backupThreadPoolExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, List<Prio1Backup> prio1BackupIndices, List<Prio2Backup> prio2BackupTemplates, List<Prio3Backup> prio3BackupTemplates, List<Prio4Backup> prio4BackupIndices, OperateProperties operateProperties, BackupRepository repository) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.prio1BackupIndices = prio1BackupIndices;
        this.prio2BackupTemplates = prio2BackupTemplates;
        this.prio3BackupTemplates = prio3BackupTemplates;
        this.prio4BackupIndices = prio4BackupIndices;
        this.repository = repository;
        this.operateProperties = operateProperties;
    }

    public void deleteBackup(Long backupId) {
        this.repository.validateRepositoryExists(this.getRepositoryName());
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        String version = this.getCurrentOperateVersion();
        for (int index = 0; index < count; ++index) {
            String snapshotName = new Metadata().setVersion(version).setPartCount(Integer.valueOf(count)).setPartNo(Integer.valueOf(index + 1)).setBackupId(backupId).buildSnapshotName();
            this.repository.deleteSnapshot(repositoryName, snapshotName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TakeBackupResponseDto takeBackup(TakeBackupRequestDto request) {
        this.repository.validateRepositoryExists(this.getRepositoryName());
        this.repository.validateNoDuplicateBackupId(this.getRepositoryName(), request.getBackupId());
        if (!this.requestsQueue.isEmpty()) {
            throw new InvalidRequestException("Another backup is running at the moment");
        }
        Queue queue = this.requestsQueue;
        synchronized (queue) {
            if (!this.requestsQueue.isEmpty()) {
                throw new InvalidRequestException("Another backup is running at the moment");
            }
            return this.scheduleSnapshots(request);
        }
    }

    private TakeBackupResponseDto scheduleSnapshots(TakeBackupRequestDto request) {
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        ArrayList<String> snapshotNames = new ArrayList<String>();
        String version = this.getCurrentOperateVersion();
        for (int index = 0; index < count; ++index) {
            List<String> indexPattern = Arrays.asList(this.getIndexPatternsOrdered()[index]);
            Metadata metadata = new Metadata().setVersion(version).setPartCount(Integer.valueOf(count)).setPartNo(Integer.valueOf(index + 1)).setBackupId(request.getBackupId());
            String snapshotName = metadata.buildSnapshotName();
            SnapshotRequest snapshotRequest = new SnapshotRequest(repositoryName, snapshotName, indexPattern, metadata);
            this.requestsQueue.offer(snapshotRequest);
            LOGGER.debug("Snapshot scheduled: {}", (Object)snapshotName);
            snapshotNames.add(snapshotName);
        }
        this.scheduleNextSnapshot();
        return new TakeBackupResponseDto().setScheduledSnapshots(snapshotNames);
    }

    private void scheduleNextSnapshot() {
        SnapshotRequest nextRequest = (SnapshotRequest)this.requestsQueue.poll();
        if (nextRequest != null) {
            this.threadPoolTaskExecutor.submit(() -> this.repository.executeSnapshotting(nextRequest, () -> this.scheduleNextSnapshot(), this.requestsQueue::clear));
            LOGGER.debug("Snapshot picked for execution: {}", (Object)nextRequest);
        }
    }

    private String getRepositoryName() {
        return this.operateProperties.getBackup().getRepositoryName();
    }

    /*
     * Exception decompiling
     */
    private String[][] getIndexPatternsOrdered() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.applyExpressionRewriter(NewAnonymousArray.java:112)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCurrentOperateVersion() {
        return this.operateProperties.getVersion().toLowerCase();
    }

    public GetBackupStateResponseDto getBackupState(Long backupId) {
        return this.repository.getBackupState(this.getRepositoryName(), backupId);
    }

    public List<GetBackupStateResponseDto> getBackups() {
        return this.repository.getBackups(this.getRepositoryName());
    }

    private static /* synthetic */ String[] lambda$getIndexPatternsOrdered$12(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$getIndexPatternsOrdered$11(Prio4Backup index) {
        return ((IndexDescriptor)index).getFullQualifiedName();
    }

    private static /* synthetic */ String[] lambda$getIndexPatternsOrdered$10(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$getIndexPatternsOrdered$9(Prio3Backup index) {
        return new String[]{((TemplateDescriptor)index).getFullQualifiedName() + "*", "-" + ((TemplateDescriptor)index).getFullQualifiedName()};
    }

    private static /* synthetic */ String[] lambda$getIndexPatternsOrdered$8(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$getIndexPatternsOrdered$7(Prio3Backup index) {
        return ((TemplateDescriptor)index).getFullQualifiedName();
    }

    private static /* synthetic */ String[] lambda$getIndexPatternsOrdered$6(int x$0) {
        return new String[x$0];
    }
}

