/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.rest;

import io.camunda.operate.webapp.api.v1.dao.DecisionRequirementsDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionRequirements;
import io.camunda.operate.webapp.api.v1.entities.Error;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.rest.ErrorController;
import io.camunda.operate.webapp.api.v1.rest.SearchController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="DecisionRequirementsControllerV1")
@RequestMapping(value={"/v1/drd"})
@Tag(name="DecisionRequirements", description="Decision Requirements API")
@Validated
public class DecisionRequirementsController
extends ErrorController
implements SearchController<DecisionRequirements> {
    public static final String URI = "/v1/drd";
    public static final String AS_XML = "/xml";
    @Autowired
    private DecisionRequirementsDao decisionRequirementsDao;

    @Operation(summary="Get decision requirements as XML by key", security={@SecurityRequirement(name="bearer-key"), @SecurityRequirement(name="cookie")}, responses={@ApiResponse(description="Success", responseCode="200"), @ApiResponse(description="API application error", responseCode="500", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Invalid request", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Requested resource not found", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/{key}/xml"}, produces={"text/xml"})
    public String xmlByKey(@Parameter(description="Key of decision requirements", required=true) @Valid @PathVariable Long key) {
        return this.decisionRequirementsDao.xmlByKey(key);
    }

    @Operation(summary="Search decision requirements", security={@SecurityRequirement(name="bearer-key"), @SecurityRequirement(name="cookie")}, responses={@ApiResponse(description="Success", responseCode="200"), @ApiResponse(description="API application error", responseCode="500", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Invalid request", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Data invalid", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Search examples", content={@Content(examples={@ExampleObject(name="All", value="{}", description="All decision requirements (default size is 10)"), @ExampleObject(name="Size of returned list", value="{ \"size\": 5 }", description="Search decision requirements and return list of size 5"), @ExampleObject(name="Sort", value="{ \"sort\": [{\"field\":\"name\",\"order\": \"ASC\"}] }", description="Search decision requirements and sort ascending by name"), @ExampleObject(name="Sort and size", value="{ \"size\": 5, \"sort\": [{\"field\":\"name\",\"order\": \"DESC\"}] }", description="Search decision requirements, sort descending by name, and return list of size 5"), @ExampleObject(name="Sort and page", value="{   \"size\": 5,    \"sort\": [{\"field\":\"name\",\"order\": \"ASC\"}],    \"searchAfter\": [      \"Invoice Business Decisions\",      \"2251799813686550\"  ] }", description="Search decision requirements, sort ascending by name, and return page of size 5.\nTo get the next page, copy the value of 'sortValues' into 'searchAfter' value.\nSort specification should match the searchAfter specification."), @ExampleObject(name="Filter and sort ", value="{   \"filter\": {      \"version\": 1    },    \"size\": 50,    \"sort\": [{\"field\":\"decisionRequirementsId\",\"order\": \"ASC\"}]}", description="Filter by version and sort by decisionRequirementsId")})})
    public Results<DecisionRequirements> search(@RequestBody(required=false) Query<DecisionRequirements> query) {
        query = query == null ? new Query() : query;
        return this.decisionRequirementsDao.search(query);
    }

    @Operation(summary="Get decision requirements by key", security={@SecurityRequirement(name="bearer-key"), @SecurityRequirement(name="cookie")}, responses={@ApiResponse(description="Success", responseCode="200"), @ApiResponse(description="API application error", responseCode="500", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Invalid request", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="Requested resource not found", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    public DecisionRequirements byKey(@Parameter(description="Key of decision requirements", required=true) @PathVariable Long key) {
        return this.decisionRequirementsDao.byKey(key);
    }
}

