/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.templates.VariableTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.VariableDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Variable;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchVariableDao
extends OpensearchKeyFilteringDao<Variable, Variable>
implements VariableDao {
    private final VariableTemplate variableIndex;

    public OpensearchVariableDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, VariableTemplate variableIndex) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.variableIndex = variableIndex;
    }

    protected String getUniqueSortKey() {
        return "key";
    }

    protected Class<Variable> getInternalDocumentModelClass() {
        return Variable.class;
    }

    protected String getIndexName() {
        return this.variableIndex.getAlias();
    }

    protected void buildFiltering(Query<Variable> query, SearchRequest.Builder request) {
        List queryTerms;
        Variable filter = (Variable)query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey()), this.queryDSLWrapper.term("scopeKey", filter.getScopeKey()), this.queryDSLWrapper.term("name", filter.getName()), this.queryDSLWrapper.term("value", filter.getValue()), this.queryDSLWrapper.term("isPreview", filter.getTruncated())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    protected Variable convertInternalToApiResult(Variable internalResult) {
        return internalResult;
    }

    protected String getKeyFieldName() {
        return "key";
    }

    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading variable for key %s", key);
    }

    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No variable found for key %s", key);
    }

    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one variables for key %s", key);
    }
}

