/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.SequenceFlowDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchSearchableDao;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.SequenceFlow;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchSequenceFlowDao
extends OpensearchSearchableDao<SequenceFlow, SequenceFlow>
implements SequenceFlowDao {
    private final SequenceFlowTemplate sequenceFlowIndex;

    public OpensearchSequenceFlowDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, SequenceFlowTemplate sequenceFlowIndex) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.sequenceFlowIndex = sequenceFlowIndex;
    }

    protected String getUniqueSortKey() {
        return "id";
    }

    protected Class<SequenceFlow> getInternalDocumentModelClass() {
        return SequenceFlow.class;
    }

    protected String getIndexName() {
        return this.sequenceFlowIndex.getAlias();
    }

    protected void buildFiltering(Query<SequenceFlow> query, SearchRequest.Builder request) {
        List queryTerms;
        SequenceFlow filter = (SequenceFlow)query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("id", filter.getId()), this.queryDSLWrapper.term("activityId", filter.getActivityId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    protected SequenceFlow convertInternalToApiResult(SequenceFlow internalResult) {
        return internalResult;
    }
}

