/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;

public abstract class OpensearchSearchableDao<T, R> {
    protected final OpensearchQueryDSLWrapper queryDSLWrapper;
    protected final OpensearchRequestDSLWrapper requestDSLWrapper;
    protected final RichOpenSearchClient richOpenSearchClient;

    public OpensearchSearchableDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient) {
        this.queryDSLWrapper = queryDSLWrapper;
        this.requestDSLWrapper = requestDSLWrapper;
        this.richOpenSearchClient = richOpenSearchClient;
    }

    public Results<T> search(Query<T> query) {
        SearchRequest.Builder request = this.buildSearchRequest(query);
        this.buildSorting(query, this.getUniqueSortKey(), request);
        this.buildFiltering(query, request);
        this.buildPaging(query, request);
        try {
            HitsMetadata results = this.richOpenSearchClient.doc().search(request, this.getInternalDocumentModelClass()).hits();
            return this.formatHitsIntoResults(results);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading incidents", (Throwable)e);
        }
    }

    protected SearchRequest.Builder buildSearchRequest(Query<T> query) {
        return this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.matchAll()));
    }

    protected abstract String getUniqueSortKey();

    protected abstract Class<R> getInternalDocumentModelClass();

    protected abstract String getIndexName();

    protected void buildSorting(Query<T> query, String uniqueSortKey, SearchRequest.Builder request) {
        List sorts = query.getSort();
        if (sorts != null) {
            sorts.forEach(sort -> {
                Query.Sort.Order order = sort.getOrder();
                if (order.equals((Object)Query.Sort.Order.DESC)) {
                    request.sort(this.queryDSLWrapper.sortOptions(sort.getField(), SortOrder.Desc), new SortOptions[0]);
                } else {
                    request.sort(this.queryDSLWrapper.sortOptions(sort.getField(), SortOrder.Asc), new SortOptions[0]);
                }
            });
        }
        request.sort(this.queryDSLWrapper.sortOptions(uniqueSortKey, SortOrder.Asc), new SortOptions[0]);
    }

    protected void buildPaging(Query<T> query, SearchRequest.Builder request) {
        Object[] searchAfter = query.getSearchAfter();
        if (searchAfter != null) {
            request.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])searchAfter));
        }
        request.size(Integer.valueOf(query.getSize()));
    }

    protected abstract void buildFiltering(Query<T> var1, SearchRequest.Builder var2);

    protected Results<T> formatHitsIntoResults(HitsMetadata<R> results) {
        List hits = results.hits();
        if (!hits.isEmpty()) {
            List<Object> items = hits.stream().map(hit -> this.convertInternalToApiResult(hit.source())).filter(Objects::nonNull).toList();
            List sortValues = ((Hit)hits.get(hits.size() - 1)).sort();
            return new Results().setTotal(results.total().value()).setItems(items).setSortValues(sortValues.toArray());
        }
        return new Results().setTotal(results.total().value());
    }

    protected abstract T convertInternalToApiResult(R var1);
}

