/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.ProcessInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.ChangeStatus;
import io.camunda.operate.webapp.api.v1.entities.ProcessInstance;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ClientException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import io.camunda.operate.webapp.writer.ProcessInstanceWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchProcessInstanceDao
extends OpensearchKeyFilteringDao<ProcessInstance, ProcessInstance>
implements ProcessInstanceDao {
    private final ListViewTemplate processInstanceIndex;
    private final ProcessInstanceWriter processInstanceWriter;
    private final OperateDateTimeFormatter dateTimeFormatter;

    public OpensearchProcessInstanceDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, ListViewTemplate processInstanceIndex, ProcessInstanceWriter processInstanceWriter, OperateDateTimeFormatter dateTimeFormatter) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.processInstanceIndex = processInstanceIndex;
        this.processInstanceWriter = processInstanceWriter;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    protected String getUniqueSortKey() {
        return "key";
    }

    protected Class<ProcessInstance> getInternalDocumentModelClass() {
        return ProcessInstance.class;
    }

    protected String getIndexName() {
        return this.processInstanceIndex.getAlias();
    }

    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<ProcessInstance> query, SearchRequest.Builder request) {
        LinkedList<Query> queryTerms = new LinkedList<Query>();
        queryTerms.add(this.queryDSLWrapper.term("joinRelation", "processInstance"));
        ProcessInstance filter = (ProcessInstance)query.getFilter();
        if (filter != null) {
            queryTerms.add(this.queryDSLWrapper.term("processInstanceKey", filter.getKey()));
            queryTerms.add(this.queryDSLWrapper.term("processDefinitionKey", filter.getProcessDefinitionKey()));
            queryTerms.add(this.queryDSLWrapper.term("parentProcessInstanceKey", filter.getParentKey()));
            queryTerms.add(this.queryDSLWrapper.term("parentFlowNodeInstanceKey", filter.getParentFlowNodeInstanceKey()));
            queryTerms.add(this.queryDSLWrapper.term("processVersion", filter.getProcessVersion()));
            queryTerms.add(this.queryDSLWrapper.term("bpmnProcessId", filter.getBpmnProcessId()));
            queryTerms.add(this.queryDSLWrapper.term("state", filter.getState()));
            queryTerms.add(this.queryDSLWrapper.term("incident", filter.getIncident()));
            queryTerms.add(this.queryDSLWrapper.term("tenantId", filter.getTenantId()));
            queryTerms.add(this.queryDSLWrapper.matchDateQuery("startDate", filter.getStartDate(), this.dateTimeFormatter.getApiDateTimeFormatString()));
            queryTerms.add(this.queryDSLWrapper.matchDateQuery("endDate", filter.getEndDate(), this.dateTimeFormatter.getApiDateTimeFormatString()));
        }
        List<Query> nonNullQueryTerms = queryTerms.stream().filter(Objects::nonNull).toList();
        request.query(this.queryDSLWrapper.and(nonNullQueryTerms));
    }

    protected ProcessInstance convertInternalToApiResult(ProcessInstance internalResult) {
        if (internalResult != null) {
            if (StringUtils.isNotEmpty((CharSequence)internalResult.getEndDate())) {
                internalResult.setEndDate(this.dateTimeFormatter.convertGeneralToApiDateTime(internalResult.getEndDate()));
            }
            if (StringUtils.isNotEmpty((CharSequence)internalResult.getStartDate())) {
                internalResult.setStartDate(this.dateTimeFormatter.convertGeneralToApiDateTime(internalResult.getStartDate()));
            }
        }
        return internalResult;
    }

    @PreAuthorize(value="hasPermission('write')")
    public ChangeStatus delete(Long key) throws APIException {
        this.byKey(key);
        try {
            this.processInstanceWriter.deleteInstanceById(key);
            return new ChangeStatus().setDeleted(1L).setMessage(String.format("Process instance and dependant data deleted for key '%s'", key));
        }
        catch (IllegalArgumentException iae) {
            throw new ClientException(iae.getMessage(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in deleting process instance and dependant data for key '%s'", key), (Throwable)e);
        }
    }

    protected List<ProcessInstance> searchByKey(Long key) {
        LinkedList<Query> queryTerms = new LinkedList<Query>();
        queryTerms.add(this.queryDSLWrapper.term("joinRelation", "processInstance"));
        queryTerms.add(this.queryDSLWrapper.term(this.getKeyFieldName(), key));
        SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.and(queryTerms)));
        return this.richOpenSearchClient.doc().searchValues(request, this.getInternalDocumentModelClass());
    }

    protected String getKeyFieldName() {
        return "processInstanceKey";
    }

    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading process instance for key %s", key);
    }

    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No process instances found for key %s", key);
    }

    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one process instances for key %s", key);
    }
}

