/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.IncidentDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.Incident;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.entities.opensearch.OpensearchIncident;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchIncidentDao
extends OpensearchKeyFilteringDao<Incident, OpensearchIncident>
implements IncidentDao {
    private final IncidentTemplate incidentIndex;
    private final OperateDateTimeFormatter dateTimeFormatter;

    public OpensearchIncidentDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, IncidentTemplate incidentIndex, OperateDateTimeFormatter dateTimeFormatter) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.incidentIndex = incidentIndex;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    protected String getKeyFieldName() {
        return "key";
    }

    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading incident for key %s", key);
    }

    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No incident found for key %s ", key);
    }

    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one incidents for key %s", key);
    }

    public Results<Incident> search(Query<Incident> query) throws APIException {
        this.mapFieldsInSort(query);
        return super.search(query);
    }

    protected String getUniqueSortKey() {
        return "key";
    }

    protected Class<OpensearchIncident> getInternalDocumentModelClass() {
        return OpensearchIncident.class;
    }

    protected String getIndexName() {
        return this.incidentIndex.getAlias();
    }

    protected void buildFiltering(Query<Incident> query, SearchRequest.Builder request) {
        List queryTerms;
        Incident filter = (Incident)query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("processDefinitionKey", filter.getProcessDefinitionKey()), this.queryDSLWrapper.term("processInstanceKey", filter.getProcessInstanceKey()), this.queryDSLWrapper.term("errorType", filter.getType()), this.queryDSLWrapper.match("errorMessage", filter.getMessage()), this.queryDSLWrapper.term("state", filter.getState()), this.queryDSLWrapper.term("jobKey", filter.getJobKey()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.matchDateQuery("creationTime", filter.getCreationTime(), this.dateTimeFormatter.getApiDateTimeFormatString())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    protected Incident convertInternalToApiResult(OpensearchIncident osIncident) {
        return new Incident().setKey(osIncident.key()).setProcessInstanceKey(osIncident.processInstanceKey()).setProcessDefinitionKey(osIncident.processDefinitionKey()).setType(osIncident.errorType()).setMessage(osIncident.errorMessage()).setCreationTime(this.dateTimeFormatter.convertGeneralToApiDateTime(osIncident.creationTime())).setState(osIncident.state()).setJobKey(osIncident.jobKey()).setTenantId(osIncident.tenantId());
    }

    private void mapFieldsInSort(Query<Incident> query) {
        if (query.getSort() == null) {
            return;
        }
        List<Query.Sort> rewrittenSort = query.getSort().stream().map(s -> s.setField(Incident.OBJECT_TO_SEARCH_MAP.getOrDefault(s.getField(), s.getField()))).toList();
        query.setSort(rewrittenSort);
    }
}

