/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.FlowNodeStatisticsDao;
import io.camunda.operate.webapp.api.v1.entities.FlowNodeStatistics;
import io.camunda.operate.webapp.opensearch.OpensearchAggregationDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchFlowNodeStatisticsDao
implements FlowNodeStatisticsDao {
    private static final int TERMS_AGG_SIZE = 10000;
    private final FlowNodeInstanceTemplate flowNodeInstanceTemplate;
    private final RichOpenSearchClient richOpenSearchClient;
    private final OpensearchQueryDSLWrapper queryDSLWrapper;
    private final OpensearchRequestDSLWrapper requestDSLWrapper;
    private final OpensearchAggregationDSLWrapper aggregationDSLWrapper;

    public OpensearchFlowNodeStatisticsDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, OpensearchAggregationDSLWrapper aggregationDSLWrapper, RichOpenSearchClient richOpenSearchClient, FlowNodeInstanceTemplate flowNodeInstanceTemplate) {
        this.flowNodeInstanceTemplate = flowNodeInstanceTemplate;
        this.richOpenSearchClient = richOpenSearchClient;
        this.queryDSLWrapper = queryDSLWrapper;
        this.requestDSLWrapper = requestDSLWrapper;
        this.aggregationDSLWrapper = aggregationDSLWrapper;
    }

    public List<FlowNodeStatistics> getFlowNodeStatisticsForProcessInstance(Long processInstanceKey) {
        SearchRequest.Builder requestBuilder = this.requestDSLWrapper.searchRequestBuilder((TemplateDescriptor)this.flowNodeInstanceTemplate).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.constantScore(this.queryDSLWrapper.term("processInstanceKey", processInstanceKey)))).aggregations("flowNodeIdAgg", this.aggregationDSLWrapper.withSubaggregations(this.aggregationDSLWrapper.termAggregation("flowNodeId", 10000), Map.of("countIncident", this.queryDSLWrapper.term("incident", true)._toAggregation(), "countCanceled", this.queryDSLWrapper.and(new Query[]{this.queryDSLWrapper.not(new Query[]{this.queryDSLWrapper.term("type", FlowNodeType.MULTI_INSTANCE_BODY.name())}), this.queryDSLWrapper.term("state", FlowNodeState.TERMINATED.name())})._toAggregation(), "countCompleted", this.queryDSLWrapper.and(new Query[]{this.queryDSLWrapper.not(new Query[]{this.queryDSLWrapper.term("type", FlowNodeType.MULTI_INSTANCE_BODY.name())}), this.queryDSLWrapper.term("state", FlowNodeState.COMPLETED.name())})._toAggregation(), "countActive", this.queryDSLWrapper.and(new Query[]{this.queryDSLWrapper.not(new Query[]{this.queryDSLWrapper.term("type", FlowNodeType.MULTI_INSTANCE_BODY.name())}), this.queryDSLWrapper.term("state", FlowNodeState.ACTIVE.name()), this.queryDSLWrapper.term("incident", false)})._toAggregation()))).size(Integer.valueOf(0));
        return ((Aggregate)this.richOpenSearchClient.doc().search(requestBuilder, Void.class).aggregations().get("flowNodeIdAgg")).sterms().buckets().array().stream().map(bucket -> new FlowNodeStatistics().setActivityId(bucket.key()).setCanceled(Long.valueOf(((Aggregate)bucket.aggregations().get("countCanceled")).filter().docCount())).setIncidents(Long.valueOf(((Aggregate)bucket.aggregations().get("countIncident")).filter().docCount())).setCompleted(Long.valueOf(((Aggregate)bucket.aggregations().get("countCompleted")).filter().docCount())).setActive(Long.valueOf(((Aggregate)bucket.aggregations().get("countActive")).filter().docCount()))).toList();
    }
}

