/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.DecisionRequirementsDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionRequirements;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionRequirementsDao
extends OpensearchKeyFilteringDao<DecisionRequirements, DecisionRequirements>
implements DecisionRequirementsDao {
    private final DecisionRequirementsIndex decisionRequirementsIndex;

    public OpensearchDecisionRequirementsDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, DecisionRequirementsIndex decisionRequirementsIndex) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.decisionRequirementsIndex = decisionRequirementsIndex;
    }

    protected String getKeyFieldName() {
        return "key";
    }

    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading decision requirements for key %s", key);
    }

    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No decision requirements found for key %s", key);
    }

    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one decision requirements for key %s", key);
    }

    public List<DecisionRequirements> byKeys(Set<Long> keys) throws APIException {
        List nonNullKeys;
        List<Object> list = nonNullKeys = keys == null ? List.of() : keys.stream().filter(Objects::nonNull).toList();
        if (nonNullKeys.isEmpty()) {
            return List.of();
        }
        try {
            SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.longTerms(this.getKeyFieldName(), nonNullKeys));
            return this.richOpenSearchClient.doc().scrollValues(request, DecisionRequirements.class);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision requirements by keys", (Throwable)e);
        }
    }

    public String xmlByKey(Long key) throws APIException {
        this.validateKey(key);
        SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.term("key", key))).source(this.queryDSLWrapper.sourceInclude(new String[]{"xml"}));
        try {
            SearchResponse response = this.richOpenSearchClient.doc().search(request, Map.class);
            if (response.hits().total().value() == 1L) {
                return ((Map)((Hit)response.hits().hits().get(0)).source()).get("xml").toString();
            }
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading decision requirements as xml for key %s", key), (Throwable)e);
        }
        throw new ResourceNotFoundException(String.format("Decision requirements for key %s not found.", key));
    }

    protected String getUniqueSortKey() {
        return "key";
    }

    protected Class<DecisionRequirements> getInternalDocumentModelClass() {
        return DecisionRequirements.class;
    }

    protected String getIndexName() {
        return this.decisionRequirementsIndex.getAlias();
    }

    protected void buildFiltering(Query<DecisionRequirements> query, SearchRequest.Builder request) {
        List queryTerms;
        DecisionRequirements filter = (DecisionRequirements)query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("id", filter.getId()), this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("decisionRequirementsId", filter.getDecisionRequirementsId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("name", filter.getName()), this.queryDSLWrapper.term("version", filter.getVersion()), this.queryDSLWrapper.term("resourceName", filter.getResourceName())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    protected DecisionRequirements convertInternalToApiResult(DecisionRequirements internalResult) {
        return internalResult;
    }
}

