/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.DecisionDefinitionDao;
import io.camunda.operate.webapp.api.v1.dao.DecisionRequirementsDao;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchKeyFilteringDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionDefinition;
import io.camunda.operate.webapp.api.v1.entities.DecisionRequirements;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionDefinitionDao
extends OpensearchKeyFilteringDao<DecisionDefinition, DecisionDefinition>
implements DecisionDefinitionDao {
    private final DecisionIndex decisionIndex;
    private final DecisionRequirementsIndex decisionRequirementsIndex;
    private final DecisionRequirementsDao decisionRequirementsDao;

    public OpensearchDecisionDefinitionDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient, DecisionIndex decisionIndex, DecisionRequirementsIndex decisionRequirementsIndex, DecisionRequirementsDao decisionRequirementsDao) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
        this.decisionIndex = decisionIndex;
        this.decisionRequirementsIndex = decisionRequirementsIndex;
        this.decisionRequirementsDao = decisionRequirementsDao;
    }

    public DecisionDefinition byKey(Long key) {
        DecisionDefinition decisionDefinition = (DecisionDefinition)super.byKey(key);
        DecisionRequirements decisionRequirements = this.decisionRequirementsDao.byKey(decisionDefinition.getDecisionRequirementsKey());
        decisionDefinition.setDecisionRequirementsName(decisionRequirements.getName());
        decisionDefinition.setDecisionRequirementsVersion(decisionRequirements.getVersion().intValue());
        return decisionDefinition;
    }

    protected String getKeyFieldName() {
        return "key";
    }

    protected String getByKeyServerReadErrorMessage(Long key) {
        return String.format("Error in reading decision definition for key %s", key);
    }

    protected String getByKeyNoResultsErrorMessage(Long key) {
        return String.format("No decision definition found for key %s", key);
    }

    protected String getByKeyTooManyResultsErrorMessage(Long key) {
        return String.format("Found more than one decision definition for key %s", key);
    }

    public Results<DecisionDefinition> search(io.camunda.operate.webapp.api.v1.entities.Query<DecisionDefinition> query) {
        Results results = super.search(query);
        List decisionDefinitions = results.getItems();
        this.populateDecisionRequirementsNameAndVersion(decisionDefinitions);
        return results;
    }

    protected String getUniqueSortKey() {
        return "key";
    }

    protected Class<DecisionDefinition> getInternalDocumentModelClass() {
        return DecisionDefinition.class;
    }

    protected String getIndexName() {
        return this.decisionIndex.getAlias();
    }

    protected void buildFiltering(io.camunda.operate.webapp.api.v1.entities.Query<DecisionDefinition> query, SearchRequest.Builder request) {
        List queryTerms;
        DecisionDefinition filter = (DecisionDefinition)query.getFilter();
        if (filter != null && !(queryTerms = Stream.of(this.queryDSLWrapper.term("id", filter.getId()), this.queryDSLWrapper.term("key", filter.getKey()), this.queryDSLWrapper.term("decisionId", filter.getDecisionId()), this.queryDSLWrapper.term("tenantId", filter.getTenantId()), this.queryDSLWrapper.term("name", filter.getName()), this.queryDSLWrapper.term("version", filter.getVersion()), this.queryDSLWrapper.term("decisionRequirementsId", filter.getDecisionRequirementsId()), this.queryDSLWrapper.term("decisionRequirementsKey", filter.getDecisionRequirementsKey()), this.buildFilteringBy(filter.getDecisionRequirementsName(), filter.getDecisionRequirementsVersion())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            request.query(this.queryDSLWrapper.and(queryTerms));
        }
    }

    protected DecisionDefinition convertInternalToApiResult(DecisionDefinition internalResult) {
        return internalResult;
    }

    private void populateDecisionRequirementsNameAndVersion(List<DecisionDefinition> decisionDefinitions) {
        Set decisionRequirementsKeys = decisionDefinitions.stream().map(DecisionDefinition::getDecisionRequirementsKey).collect(Collectors.toSet());
        List decisionRequirements = this.decisionRequirementsDao.byKeys(decisionRequirementsKeys);
        HashMap decisionReqMap = new HashMap();
        decisionRequirements.forEach(decisionReq -> decisionReqMap.put(decisionReq.getKey(), decisionReq));
        decisionDefinitions.forEach(decisionDef -> {
            DecisionRequirements decisionReq;
            DecisionRequirements decisionRequirements = decisionReq = decisionDef.getDecisionRequirementsKey() == null ? null : (DecisionRequirements)decisionReqMap.get(decisionDef.getDecisionRequirementsKey());
            if (decisionReq != null) {
                decisionDef.setDecisionRequirementsName(decisionReq.getName());
                decisionDef.setDecisionRequirementsVersion(decisionReq.getVersion().intValue());
            }
        });
    }

    private Query buildFilteringBy(String decisionRequirementsName, Integer decisionRequirementsVersion) {
        try {
            LinkedList<Query> queryTerms = new LinkedList<Query>();
            queryTerms.add(this.queryDSLWrapper.term("name", decisionRequirementsName));
            queryTerms.add(this.queryDSLWrapper.term("version", decisionRequirementsVersion));
            Query query = this.queryDSLWrapper.and(queryTerms);
            if (query == null) {
                return null;
            }
            SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.decisionRequirementsIndex.getAlias()).query(this.queryDSLWrapper.withTenantCheck(query)).source(this.queryDSLWrapper.sourceInclude(new String[]{"key"}));
            List decisionRequirements = this.richOpenSearchClient.doc().scrollValues(request, DecisionRequirements.class);
            List<Long> nonNullKeys = decisionRequirements.stream().map(DecisionRequirements::getKey).filter(Objects::nonNull).toList();
            if (nonNullKeys.isEmpty()) {
                return this.queryDSLWrapper.matchNone();
            }
            return this.queryDSLWrapper.longTerms("decisionRequirementsKey", nonNullKeys);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision requirements by name and version", (Throwable)e);
        }
    }
}

