/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.SequenceFlowDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.entities.SequenceFlow;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchSequenceFlowDaoV1")
public class ElasticsearchSequenceFlowDao
extends ElasticsearchDao<SequenceFlow>
implements SequenceFlowDao {
    @Autowired
    private SequenceFlowTemplate sequenceFlowIndex;

    protected void buildFiltering(Query<SequenceFlow> query, SearchSourceBuilder searchSourceBuilder) {
        SequenceFlow filter = (SequenceFlow)query.getFilter();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (filter != null) {
            queryBuilders.add(this.buildTermQuery("id", filter.getId()));
            queryBuilders.add(this.buildTermQuery("activityId", filter.getActivityId()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildTermQuery("processInstanceKey", filter.getProcessInstanceKey()));
        }
        searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
    }

    public Results<SequenceFlow> search(Query<SequenceFlow> query) throws APIException {
        this.logger.debug("search {}", query);
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "id", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.sequenceFlowIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List sequenceFlows = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, arg_0 -> this.searchHitToSequenceFlow(arg_0));
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(sequenceFlows).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading sequence flows", (Throwable)e);
        }
    }

    protected SequenceFlow searchHitToSequenceFlow(SearchHit searchHit) {
        Map searchHitAsMap = searchHit.getSourceAsMap();
        return new SequenceFlow().setId((String)searchHitAsMap.get("id")).setActivityId((String)searchHitAsMap.get("activityId")).setProcessInstanceKey((Long)searchHitAsMap.get("processInstanceKey")).setTenantId((String)searchHitAsMap.get("tenantId"));
    }
}

