/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.DecisionRequirementsDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionRequirements;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchDecisionRequirementsDaoV1")
public class ElasticsearchDecisionRequirementsDao
extends ElasticsearchDao<DecisionRequirements>
implements DecisionRequirementsDao {
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;

    public DecisionRequirements byKey(Long key) throws APIException {
        List decisionRequirements;
        try {
            decisionRequirements = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading decision requirements for key %s", key), (Throwable)e);
        }
        if (decisionRequirements.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No decision requirements found for key %s", key));
        }
        if (decisionRequirements.size() > 1) {
            throw new ServerException(String.format("Found more than one decision requirements for key %s", key));
        }
        return (DecisionRequirements)decisionRequirements.get(0);
    }

    public List<DecisionRequirements> byKeys(Set<Long> keys) throws APIException {
        List nonNullKeys;
        List<Object> list = nonNullKeys = keys == null ? List.of() : keys.stream().filter(Objects::nonNull).toList();
        if (nonNullKeys.isEmpty()) {
            return List.of();
        }
        try {
            return this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termsQuery((String)"key", nonNullKeys)));
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision requirements by keys", (Throwable)e);
        }
    }

    public String xmlByKey(Long key) throws APIException {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionRequirementsIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)).fetchSource("xml", null));
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                Map result = response.getHits().getHits()[0].getSourceAsMap();
                return (String)result.get("xml");
            }
        }
        catch (IOException e) {
            throw new ServerException(String.format("Error in reading decision requirements as xml for key %s", key), (Throwable)e);
        }
        throw new ResourceNotFoundException(String.format("Decision requirements for key %s not found.", key));
    }

    public Results<DecisionRequirements> search(Query<DecisionRequirements> query) throws APIException {
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "key", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.decisionRequirementsIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List decisionRequirements = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, (ObjectMapper)this.objectMapper, DecisionRequirements.class);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(decisionRequirements).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision requirements", (Throwable)e);
        }
    }

    protected List<DecisionRequirements> searchFor(SearchSourceBuilder searchSource) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionRequirementsIndex.getAlias()}).source(searchSource);
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, DecisionRequirements.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
    }

    protected void buildFiltering(Query<DecisionRequirements> query, SearchSourceBuilder searchSourceBuilder) {
        DecisionRequirements filter = (DecisionRequirements)query.getFilter();
        if (filter != null) {
            ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
            queryBuilders.add(this.buildTermQuery("id", filter.getId()));
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("decisionRequirementsId", filter.getDecisionRequirementsId()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildTermQuery("name", filter.getName()));
            queryBuilders.add(this.buildTermQuery("version", filter.getVersion()));
            queryBuilders.add(this.buildTermQuery("resourceName", filter.getResourceName()));
            searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
        }
    }
}

