/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.DecisionInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionInstance;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchDecisionInstanceDaoV1")
public class ElasticsearchDecisionInstanceDao
extends ElasticsearchDao<DecisionInstance>
implements DecisionInstanceDao {
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;

    public DecisionInstance byId(String id) throws APIException {
        List decisionInstances;
        try {
            decisionInstances = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading decision instance for id %s", id), (Throwable)e);
        }
        if (decisionInstances.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No decision instance found for id %s", id));
        }
        if (decisionInstances.size() > 1) {
            throw new ServerException(String.format("Found more than one decision instance for id %s", id));
        }
        return (DecisionInstance)decisionInstances.get(0);
    }

    private List<DecisionInstance> mapSearchHits(SearchHit[] searchHitArray) {
        List decisionInstances = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, (ObjectMapper)this.objectMapper, DecisionInstance.class);
        if (decisionInstances != null) {
            for (DecisionInstance di : decisionInstances) {
                di.setEvaluationDate(this.dateTimeFormatter.convertGeneralToApiDateTime(di.getEvaluationDate()));
            }
        }
        return decisionInstances;
    }

    public Results<DecisionInstance> search(Query<DecisionInstance> query) throws APIException {
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "id", new SearchSourceBuilder()).fetchSource(null, new String[]{"evaluatedInputs", "evaluatedOutputs"});
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.decisionInstanceTemplate.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List decisionInstances = this.mapSearchHits(searchHitArray);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(decisionInstances).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision instance", (Throwable)e);
        }
    }

    protected void buildFiltering(Query<DecisionInstance> query, SearchSourceBuilder searchSourceBuilder) {
        DecisionInstance filter = (DecisionInstance)query.getFilter();
        if (filter != null) {
            ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
            queryBuilders.add(this.buildTermQuery("id", filter.getId()));
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("state", filter.getState() == null ? null : filter.getState().name()));
            queryBuilders.add(this.buildMatchDateQuery("evaluationDate", filter.getEvaluationDate()));
            queryBuilders.add(this.buildTermQuery("evaluationFailure", filter.getEvaluationFailure()));
            queryBuilders.add(this.buildTermQuery("processDefinitionKey", filter.getProcessDefinitionKey()));
            queryBuilders.add(this.buildTermQuery("processInstanceKey", filter.getProcessInstanceKey()));
            queryBuilders.add(this.buildTermQuery("decisionId", filter.getDecisionId()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildTermQuery("decisionDefinitionId", filter.getDecisionDefinitionId()));
            queryBuilders.add(this.buildTermQuery("decisionName", filter.getDecisionName()));
            queryBuilders.add(this.buildTermQuery("decisionVersion", filter.getDecisionVersion()));
            queryBuilders.add(this.buildTermQuery("decisionType", filter.getDecisionType() == null ? null : filter.getDecisionType().name()));
            searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
        }
    }

    protected List<DecisionInstance> searchFor(SearchSourceBuilder searchSource) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionInstanceTemplate.getAlias()}).source(searchSource);
        List decisionInstances = (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, DecisionInstance.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
        if (decisionInstances != null) {
            for (DecisionInstance di : decisionInstances) {
                di.setEvaluationDate(this.dateTimeFormatter.convertGeneralToApiDateTime(di.getEvaluationDate()));
            }
        }
        return decisionInstances;
    }
}

