/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.DecisionDefinitionDao;
import io.camunda.operate.webapp.api.v1.dao.DecisionRequirementsDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.DecisionDefinition;
import io.camunda.operate.webapp.api.v1.entities.DecisionRequirements;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchDecisionDefinitionDaoV1")
public class ElasticsearchDecisionDefinitionDao
extends ElasticsearchDao<DecisionDefinition>
implements DecisionDefinitionDao {
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;
    @Autowired
    private DecisionRequirementsDao decisionRequirementsDao;

    public DecisionDefinition byKey(Long key) throws APIException {
        List decisionDefinitions;
        try {
            decisionDefinitions = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading decision definition for key %s", key), (Throwable)e);
        }
        if (decisionDefinitions.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No decision definition found for key %s", key));
        }
        if (decisionDefinitions.size() > 1) {
            throw new ServerException(String.format("Found more than one decision definition for key %s", key));
        }
        DecisionDefinition decisionDefinition = (DecisionDefinition)decisionDefinitions.get(0);
        DecisionRequirements decisionRequirements = this.decisionRequirementsDao.byKey(decisionDefinition.getDecisionRequirementsKey());
        decisionDefinition.setDecisionRequirementsName(decisionRequirements.getName());
        decisionDefinition.setDecisionRequirementsVersion(decisionRequirements.getVersion().intValue());
        return decisionDefinition;
    }

    public Results<DecisionDefinition> search(Query<DecisionDefinition> query) throws APIException {
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "key", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.decisionIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List decisionDefinitions = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, (ObjectMapper)this.objectMapper, DecisionDefinition.class);
                this.populateDecisionRequirementsNameAndVersion(decisionDefinitions);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(decisionDefinitions).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision definitions", (Throwable)e);
        }
    }

    protected List<DecisionDefinition> searchFor(SearchSourceBuilder searchSource) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionIndex.getAlias()}).source(searchSource);
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, DecisionDefinition.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
    }

    protected void buildFiltering(Query<DecisionDefinition> query, SearchSourceBuilder searchSourceBuilder) {
        DecisionDefinition filter = (DecisionDefinition)query.getFilter();
        if (filter != null) {
            ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
            queryBuilders.add(this.buildTermQuery("id", filter.getId()));
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("decisionId", filter.getDecisionId()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildTermQuery("name", filter.getName()));
            queryBuilders.add(this.buildTermQuery("version", filter.getVersion()));
            queryBuilders.add(this.buildTermQuery("decisionRequirementsId", filter.getDecisionRequirementsId()));
            queryBuilders.add(this.buildTermQuery("decisionRequirementsKey", filter.getDecisionRequirementsKey()));
            queryBuilders.add(this.buildFilteringBy(filter.getDecisionRequirementsName(), filter.getDecisionRequirementsVersion()));
            searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
        }
    }

    private QueryBuilder buildFilteringBy(String decisionRequirementsName, Integer decisionRequirementsVersion) {
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        queryBuilders.add(this.buildTermQuery("name", decisionRequirementsName));
        queryBuilders.add(this.buildTermQuery("version", decisionRequirementsVersion));
        QueryBuilder query = ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0]));
        if (query == null) {
            return null;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).fetchSource("key", null);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.decisionRequirementsIndex.getAlias()}).source(searchSourceBuilder);
        try {
            List decisionRequirements = (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, DecisionRequirements.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
            List<Long> nonNullKeys = decisionRequirements.stream().map(DecisionRequirements::getKey).filter(Objects::nonNull).toList();
            if (nonNullKeys.isEmpty()) {
                return ElasticsearchUtil.createMatchNoneQuery();
            }
            return QueryBuilders.termsQuery((String)"decisionRequirementsKey", nonNullKeys);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading decision requirements by name and version", (Throwable)e);
        }
    }

    private void populateDecisionRequirementsNameAndVersion(List<DecisionDefinition> decisionDefinitions) {
        Set decisionRequirementsKeys = decisionDefinitions.stream().map(DecisionDefinition::getDecisionRequirementsKey).collect(Collectors.toSet());
        List decisionRequirements = this.decisionRequirementsDao.byKeys(decisionRequirementsKeys);
        HashMap decisionReqMap = new HashMap();
        decisionRequirements.forEach(decisionReq -> decisionReqMap.put(decisionReq.getKey(), decisionReq));
        decisionDefinitions.forEach(decisionDef -> {
            DecisionRequirements decisionReq;
            DecisionRequirements decisionRequirements = decisionReq = decisionDef.getDecisionRequirementsKey() == null ? null : (DecisionRequirements)decisionReqMap.get(decisionDef.getDecisionRequirementsKey());
            if (decisionReq != null) {
                decisionDef.setDecisionRequirementsName(decisionReq.getName());
                decisionDef.setDecisionRequirementsVersion(decisionReq.getVersion().intValue());
            }
        });
    }
}

