/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.connect.OperateDateTimeFormatter;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.webapp.api.v1.entities.Query;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ElasticsearchDao<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="esClient")
    protected RestHighLevelClient elasticsearch;
    @Autowired
    protected TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected OperateDateTimeFormatter dateTimeFormatter;

    protected void buildSorting(Query<T> query, String uniqueSortKey, SearchSourceBuilder searchSourceBuilder) {
        List sorts = query.getSort();
        if (sorts != null) {
            searchSourceBuilder.sort(sorts.stream().map(sort -> {
                Query.Sort.Order order = sort.getOrder();
                FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)sort.getField());
                if (order.equals((Object)Query.Sort.Order.DESC)) {
                    return (FieldSortBuilder)sortBuilder.order(SortOrder.DESC);
                }
                return (FieldSortBuilder)sortBuilder.order(SortOrder.ASC);
            }).collect(Collectors.toList()));
        }
        searchSourceBuilder.sort(SortBuilders.fieldSort((String)uniqueSortKey).order(SortOrder.ASC));
    }

    protected void buildPaging(Query<T> query, SearchSourceBuilder searchSourceBuilder) {
        Object[] searchAfter = query.getSearchAfter();
        if (searchAfter != null) {
            searchSourceBuilder.searchAfter(searchAfter);
        }
        searchSourceBuilder.size(query.getSize());
    }

    protected SearchSourceBuilder buildQueryOn(Query<T> query, String uniqueKey, SearchSourceBuilder searchSourceBuilder) {
        this.logger.debug("Build query for Elasticsearch from query {}", query);
        this.buildSorting(query, uniqueKey, searchSourceBuilder);
        this.buildPaging(query, searchSourceBuilder);
        this.buildFiltering(query, searchSourceBuilder);
        return searchSourceBuilder;
    }

    protected abstract void buildFiltering(Query<T> var1, SearchSourceBuilder var2);

    protected QueryBuilder buildTermQuery(String name, String value) {
        if (!ConversionUtils.stringIsEmpty((String)value)) {
            return QueryBuilders.termQuery((String)name, (String)value);
        }
        return null;
    }

    protected QueryBuilder buildTermQuery(String name, Integer value) {
        if (value != null) {
            return QueryBuilders.termQuery((String)name, (Object)value);
        }
        return null;
    }

    protected QueryBuilder buildTermQuery(String name, Long value) {
        if (value != null) {
            return QueryBuilders.termQuery((String)name, (Object)value);
        }
        return null;
    }

    protected QueryBuilder buildTermQuery(String name, Boolean value) {
        if (value != null) {
            return QueryBuilders.termQuery((String)name, (Object)value);
        }
        return null;
    }

    protected QueryBuilder buildMatchQuery(String name, String value) {
        if (value != null) {
            return QueryBuilders.matchQuery((String)name, (Object)value).operator(Operator.AND);
        }
        return null;
    }

    protected QueryBuilder buildMatchDateQuery(String name, String dateAsString) {
        if (dateAsString != null) {
            return QueryBuilders.rangeQuery((String)name).gte((Object)dateAsString).lte((Object)dateAsString).format(this.dateTimeFormatter.getApiDateTimeFormatString());
        }
        return null;
    }
}

