/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api;

import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiConfig {
    @Bean
    public GroupedOpenApi apiV1() {
        return this.apiDefinitionFor("v1");
    }

    private GroupedOpenApi apiDefinitionFor(String version) {
        return GroupedOpenApi.builder().group(version).addOpenApiCustomizer(openApi -> openApi.info(this.getPublicAPIInfo()).getComponents().addSecuritySchemes("cookie", new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.COOKIE).name("OPERATE-SESSION")).addSecuritySchemes("bearer-key", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT"))).packagesToScan(new String[]{"io.camunda.operate.webapp.api." + version}).pathsToMatch(new String[]{"/" + version + "/**"}).build();
    }

    private Info getPublicAPIInfo() {
        return new Info().title("Operate Public API").version("1.0.0").description("To access active and completed process instances in Operate for monitoring and troubleshooting").contact(new Contact().url("https://www.camunda.com")).license(new License().name("License").url("https://docs.camunda.io/docs/reference/licenses/"));
    }
}

