/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp;

import io.camunda.operate.OperateProfileService;
import io.camunda.operate.util.ConversionUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class ForwardErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardErrorController.class);
    @Autowired
    private OperateProfileService operateProfileService;

    @GetMapping(value={"/{regex:[\\w-]+}", "/**/{regex:[\\w-]+}"})
    public String forward404(HttpServletRequest request) {
        String requestedURI = request.getRequestURI().substring(request.getContextPath().length());
        if (this.operateProfileService.isLoginDelegated() && this.isNotLoggedIn()) {
            return this.saveRequestAndRedirectToLogin(request, requestedURI);
        }
        return "forward:/";
    }

    private String saveRequestAndRedirectToLogin(HttpServletRequest request, String requestedURI) {
        LOGGER.warn("Requested path {}, but not authenticated. Redirect to  {} ", (Object)requestedURI, (Object)"/api/login");
        String queryString = request.getQueryString();
        if (ConversionUtils.stringIsEmpty((String)queryString)) {
            request.getSession(true).setAttribute("requestedUrl", (Object)requestedURI);
        } else {
            request.getSession(true).setAttribute("requestedUrl", (Object)(requestedURI + "?" + queryString));
        }
        return "forward:/api/login";
    }

    private boolean isNotLoggedIn() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof AnonymousAuthenticationToken || !authentication.isAuthenticated();
    }
}

