/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.operate.Application;
import io.camunda.operate.OperateProfileService;
import io.camunda.operate.data.DataGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import org.springframework.core.env.ConfigurableEnvironment;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@ComponentScan(basePackages={"io.camunda.operate"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"io\\.camunda\\.operate\\.zeebeimport\\..*"}), @ComponentScan.Filter(type=FilterType.REGEX, pattern={"io\\.camunda\\.operate\\.webapp\\..*"}), @ComponentScan.Filter(type=FilterType.REGEX, pattern={"io\\.camunda\\.operate\\.archiver\\..*"})}, nameGenerator=FullyQualifiedAnnotationBeanNameGenerator.class)
@EnableAutoConfiguration
public class Application {
    public static final String OPERATE_STATIC_RESOURCES_LOCATION = "classpath:/META-INF/resources/operate/";
    public static final String SPRING_THYMELEAF_PREFIX_KEY = "spring.thymeleaf.prefix";
    public static final String SPRING_THYMELEAF_PREFIX_VALUE = "classpath:/META-INF/resources/operate/";
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setProperty("spring.config.location", "optional:classpath:/,optional:classpath:/config/,optional:file:./,optional:file:./config/");
        System.setProperty("spring.web.resources.add-mappings", "true");
        System.setProperty("spring.web.resources.static-locations", "classpath:/META-INF/resources/operate/");
        System.setProperty("spring.banner.location", "classpath:/operate-banner.txt");
        SpringApplication springApplication = new SpringApplication(new Class[]{Application.class});
        springApplication.setAdditionalProfiles(new String[]{"operate"});
        springApplication.setAddCommandLineProperties(true);
        springApplication.addListeners(new ApplicationListener[]{new ApplicationErrorListener()});
        Application.setDefaultProperties((SpringApplication)springApplication);
        Application.setDefaultAuthProfile((SpringApplication)springApplication);
        springApplication.run(args);
    }

    private static void setDefaultAuthProfile(SpringApplication springApplication) {
        springApplication.addInitializers(new ApplicationContextInitializer[]{configurableApplicationContext -> {
            ConfigurableEnvironment env = configurableApplicationContext.getEnvironment();
            Set<String> activeProfiles = Set.of(env.getActiveProfiles());
            if (OperateProfileService.AUTH_PROFILES.stream().noneMatch(activeProfiles::contains)) {
                env.addActiveProfile("auth");
            }
        }});
    }

    private static void setDefaultProperties(SpringApplication springApplication) {
        HashMap defaultsProperties = new HashMap();
        defaultsProperties.putAll(Application.getWebProperties());
        defaultsProperties.putAll(Application.getManagementProperties());
        springApplication.setDefaultProperties(defaultsProperties);
    }

    private static Map<String, Object> getWebProperties() {
        return Map.of("server.servlet.session.cookie.name", "OPERATE-SESSION", "spring.thymeleaf.check-template-location", "true", "spring.thymeleaf.prefix", "classpath:/META-INF/resources/operate/", "spring.mvc.pathmatch.matching-strategy", "ANT_PATH_MATCHER", "server.error.include-message", "always");
    }

    public static Map<String, Object> getManagementProperties() {
        return Map.of("management.health.defaults.enabled", "false", "management.endpoint.health.probes.enabled", "true", "management.endpoints.web.exposure.include", "health, prometheus, loggers, usage-metrics, backups", "management.endpoint.health.group.readiness.include", "readinessState,indicesCheck");
    }

    @Bean(name={"dataGenerator"})
    @ConditionalOnMissingBean
    public DataGenerator stubDataGenerator() {
        LOGGER.debug("Create Data generator stub");
        return DataGenerator.DO_NOTHING;
    }
}

