/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.data.usertest;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.FailJobCommandStep1;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.client.api.worker.JobWorker;
import io.camunda.operate.data.AbstractDataGenerator;
import io.camunda.operate.data.util.NameGenerator;
import io.camunda.operate.util.PayloadUtil;
import io.camunda.operate.util.ThreadUtil;
import io.camunda.operate.util.ZeebeTestUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component(value="dataGenerator")
@Profile(value={"usertest-data"})
public class UserTestDataGenerator
extends AbstractDataGenerator {
    public static final int JOB_WORKER_TIMEOUT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTestDataGenerator.class);
    private static final String TENANT_B = "tenantB";
    protected List<Long> processInstanceKeys = new ArrayList<Long>();
    protected List<Long> doNotTouchProcessInstanceKeys = new ArrayList<Long>();
    protected List<JobWorker> jobWorkers = new ArrayList<JobWorker>();
    @Autowired
    protected PayloadUtil payloadUtil;

    @Override
    public boolean createZeebeData(boolean manuallyCalled) {
        if (!super.createZeebeData(manuallyCalled)) {
            return false;
        }
        LOGGER.debug("Test data will be generated");
        this.createInputOutputMappingInstances();
        this.createProcessWithoutInstances();
        this.createProcessWithInstancesThatHasOnlyIncidents(5 + ThreadLocalRandom.current().nextInt(17), 5 + ThreadLocalRandom.current().nextInt(17));
        this.createProcessWithInstancesWithoutIncidents(5 + ThreadLocalRandom.current().nextInt(23), 5 + ThreadLocalRandom.current().nextInt(23));
        this.createAndStartProcessWithLargeVariableValue();
        this.createAndStartProcessWithLotOfVariables();
        this.deployVersion1();
        this.createSpecialDataV1();
        this.startProcessInstances(1);
        this.deployVersion2();
        this.createSpecialDataV2();
        this.startProcessInstances(2);
        this.deployVersion3();
        this.startProcessInstances(3);
        this.deployVersion4();
        this.startProcessInstances(4);
        this.createOperations();
        this.progressProcessInstances();
        return true;
    }

    private void createInputOutputMappingInstances() {
        LOGGER.debug("Create input/output mapping process instances");
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"develop/always-completing-process.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"develop/input-output-mappings-process.bpmn"});
        ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"Process_b1711b2e-ec8e-4dad-908c-8c12e028f32f", null);
    }

    private void createAndStartProcessWithLargeVariableValue() {
        LOGGER.debug("Deploy and start process with large variable value >32kb");
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/single-task.bpmn"});
        String jsonString = this.payloadUtil.readStringFromClasspath("/usertest/large-payload.json");
        ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"bigVarProcess", (String)jsonString);
    }

    private void createAndStartProcessWithLotOfVariables() {
        StringBuffer vars = new StringBuffer("{");
        for (char letter1 = 'a'; letter1 <= 'z'; letter1 = (char)((char)(letter1 + 1))) {
            for (char letter2 = 'a'; letter2 <= 'z'; letter2 = (char)(letter2 + '\u0001')) {
                if (vars.length() > 1) {
                    vars.append(",\n");
                }
                String str = Character.toString(letter1) + Character.toString(letter2);
                vars.append("\"").append(str).append("\": \"value_").append(str).append("\"");
            }
        }
        vars.append("}");
        ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"bigVarProcess", (String)vars.toString());
    }

    public void createSpecialDataV1() {
        this.doNotTouchProcessInstanceKeys.add(this.startLoanProcess());
        long instanceKey2 = this.startLoanProcess();
        this.completeTask(instanceKey2, "reviewLoanRequest", null);
        this.failTask(instanceKey2, "checkSchufa", "Schufa system is not accessible");
        this.doNotTouchProcessInstanceKeys.add(instanceKey2);
        long instanceKey3 = this.startLoanProcess();
        this.completeTask(instanceKey3, "reviewLoanRequest", null);
        this.completeTask(instanceKey3, "checkSchufa", null);
        ZeebeTestUtil.cancelProcessInstance((boolean)true, (CamundaClient)this.client, (long)instanceKey3);
        this.doNotTouchProcessInstanceKeys.add(instanceKey3);
        long instanceKey4 = this.startLoanProcess();
        this.completeTask(instanceKey4, "reviewLoanRequest", null);
        this.completeTask(instanceKey4, "checkSchufa", null);
        this.completeTask(instanceKey4, "sendTheLoanDecision", null);
        this.doNotTouchProcessInstanceKeys.add(instanceKey4);
        this.doNotTouchProcessInstanceKeys.add(this.startOrderProcess());
        long instanceKey5 = this.startOrderProcess();
        this.completeTask(instanceKey5, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.failTask(instanceKey5, "shipArticles", "Cannot connect to server delivery05");
        this.doNotTouchProcessInstanceKeys.add(instanceKey5);
        long instanceKey6 = this.startOrderProcess();
        this.completeTask(instanceKey6, "checkPayment", "{\"paid\":false}");
        ZeebeTestUtil.cancelProcessInstance((boolean)true, (CamundaClient)this.client, (long)instanceKey6);
        this.doNotTouchProcessInstanceKeys.add(instanceKey6);
        long instanceKey7 = this.startOrderProcess();
        this.completeTask(instanceKey7, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey7, "shipArticles", "{\"orderStatus\":\"SHIPPED\"}");
        this.doNotTouchProcessInstanceKeys.add(instanceKey7);
        this.doNotTouchProcessInstanceKeys.add(this.startFlightRegistrationProcess());
        long instanceKey8 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey8, "registerPassenger", null);
        this.doNotTouchProcessInstanceKeys.add(instanceKey8);
        long instanceKey9 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey9, "registerPassenger", null);
        this.failTask(instanceKey9, "registerCabinBag", "No more stickers available");
        this.doNotTouchProcessInstanceKeys.add(instanceKey9);
        long instanceKey10 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey10, "registerPassenger", null);
        this.completeTask(instanceKey10, "registerCabinBag", "{\"luggage\":true}");
        ZeebeTestUtil.cancelProcessInstance((boolean)true, (CamundaClient)this.client, (long)instanceKey10);
        this.doNotTouchProcessInstanceKeys.add(instanceKey10);
        long instanceKey11 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey11, "registerPassenger", null);
        this.completeTask(instanceKey11, "registerCabinBag", "{\"luggage\":false}");
        this.completeTask(instanceKey11, "printOutBoardingPass", null);
        this.doNotTouchProcessInstanceKeys.add(instanceKey11);
    }

    public void createSpecialDataV2() {
        long instanceKey4 = this.startOrderProcess();
        this.completeTask(instanceKey4, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey4, "checkItems", "{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}");
        this.doNotTouchProcessInstanceKeys.add(instanceKey4);
        long instanceKey5 = this.startOrderProcess();
        this.completeTask(instanceKey5, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.failTask(instanceKey5, "checkItems", "Order information is not complete");
        this.doNotTouchProcessInstanceKeys.add(instanceKey5);
        long instanceKey3 = this.startOrderProcess();
        this.completeTask(instanceKey3, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey3, "checkItems", "{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}");
        this.failTask(instanceKey3, "shipArticles", "Cannot connect to server delivery05");
        this.doNotTouchProcessInstanceKeys.add(instanceKey3);
        long instanceKey2 = this.startOrderProcess();
        this.completeTask(instanceKey2, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey2, "checkItems", "{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}");
        this.failTask(instanceKey2, "shipArticles", "Order information is not complete");
        this.doNotTouchProcessInstanceKeys.add(instanceKey2);
        long instanceKey1 = this.startOrderProcess();
        this.completeTask(instanceKey1, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey1, "checkItems", "{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}");
        this.failTask(instanceKey1, "shipArticles", "Cannot connect to server delivery05");
        this.doNotTouchProcessInstanceKeys.add(instanceKey1);
        long instanceKey7 = this.startOrderProcess();
        this.completeTask(instanceKey7, "checkPayment", "{\"paid\":true,\"orderStatus\": \"PAID\"}");
        this.completeTask(instanceKey7, "checkItems", "{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}");
        this.completeTask(instanceKey7, "shipArticles", "{\"orderStatus\":\"SHIPPED\"}");
        this.doNotTouchProcessInstanceKeys.add(instanceKey7);
        long instanceKey6 = this.startOrderProcess();
        this.completeTask(instanceKey6, "checkPayment", "{\"paid\":false}");
        ZeebeTestUtil.cancelProcessInstance((boolean)true, (CamundaClient)this.client, (long)instanceKey6);
        this.doNotTouchProcessInstanceKeys.add(instanceKey6);
        this.doNotTouchProcessInstanceKeys.add(this.startFlightRegistrationProcess());
        long instanceKey8 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey8, "registerPassenger", null);
        this.doNotTouchProcessInstanceKeys.add(instanceKey8);
        long instanceKey9 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey9, "registerPassenger", null);
        this.failTask(instanceKey9, "registerCabinBag", "Cannot connect to server fly-host");
        this.doNotTouchProcessInstanceKeys.add(instanceKey9);
        long instanceKey10 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey10, "registerPassenger", null);
        this.completeTask(instanceKey10, "registerCabinBag", "{\"luggage\":true}");
        ZeebeTestUtil.cancelProcessInstance((boolean)true, (CamundaClient)this.client, (long)instanceKey10);
        this.doNotTouchProcessInstanceKeys.add(instanceKey10);
        long instanceKey11 = this.startFlightRegistrationProcess();
        this.completeTask(instanceKey11, "registerPassenger", null);
        this.completeTask(instanceKey11, "registerCabinBag", "{\"luggage\":true}");
        this.completeTask(instanceKey11, "determineLuggageWeight", "{\"luggageWeight\":21}");
        this.completeTask(instanceKey11, "registerLuggage", null);
        this.completeTask(instanceKey11, "printOutBoardingPass", null);
        this.doNotTouchProcessInstanceKeys.add(instanceKey11);
    }

    public void completeTask(long processInstanceKey, String jobType, String payload) {
        int attempts;
        CompleteJobHandler completeJobHandler = new CompleteJobHandler(payload, processInstanceKey);
        JobWorker jobWorker = this.client.newWorker().jobType(jobType).handler((JobHandler)completeJobHandler).name("operate").timeout(Duration.ofSeconds(3L)).pollInterval(Duration.ofMillis(100L)).open();
        for (attempts = 0; !completeJobHandler.isTaskCompleted() && attempts < 10; ++attempts) {
            ThreadUtil.sleepFor((long)200L);
        }
        if (attempts == 10) {
            LOGGER.debug("Could not complete the task {} for process instance id {}", (Object)jobType, (Object)processInstanceKey);
        }
        jobWorker.close();
    }

    public void failTask(long processInstanceKey, String jobType, String errorMessage) {
        int attempts;
        FailJobHandler failJobHandler = new FailJobHandler(processInstanceKey, errorMessage);
        JobWorker jobWorker = this.client.newWorker().jobType(jobType).handler((JobHandler)failJobHandler).name("operate").timeout(Duration.ofSeconds(3L)).pollInterval(Duration.ofMillis(100L)).open();
        for (attempts = 0; !failJobHandler.isTaskFailed() && attempts < 10; ++attempts) {
            ThreadUtil.sleepFor((long)200L);
        }
        if (attempts == 10) {
            LOGGER.debug("Could not fail the task {} for process instance id {}", (Object)jobType, (Object)processInstanceKey);
        }
        jobWorker.close();
    }

    protected void progressProcessInstances() {
        this.jobWorkers.add(this.progressReviewLoanRequestTask());
        this.jobWorkers.add(this.progressCheckSchufaTask());
        this.jobWorkers.add(this.progressSimpleTask("sendTheLoanDecision"));
        this.jobWorkers.add(this.progressSimpleTask("requestPayment", 1));
        this.jobWorkers.add(this.progressOrderProcessCheckItems());
        this.jobWorkers.add(this.progressSimpleTask("requestWarehouse"));
        this.jobWorkers.add(this.progressSimpleTask("registerPassenger", 1));
        this.jobWorkers.add(this.progressAlwaysFailingTask());
        this.jobWorkers.add(this.progressSimpleTask("peterTask"));
        this.jobWorkers.add(this.progressSimpleTask("checkItems"));
        this.jobWorkers.addAll(this.progressMultiInstanceTasks());
        this.scheduler.schedule(() -> this.startProcessInstances(3), 1L, TimeUnit.MINUTES);
        this.scheduler.schedule(() -> {
            for (JobWorker jobWorker : this.jobWorkers) {
                jobWorker.close();
            }
        }, 1000L, TimeUnit.SECONDS);
        this.scheduler.schedule(() -> this.cancelSomeInstances(), 510L, TimeUnit.SECONDS);
    }

    private JobWorker progressAlwaysFailingTask() {
        return this.client.newWorker().jobType("alwaysFailingTask").handler((jobClient, job) -> {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Throwable().printStackTrace(pw);
            String errorMessage = "Something went wrong. \n" + sw.toString();
            jobClient.newFailCommand(job.getKey()).retries(0).errorMessage(errorMessage).send().join();
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private List<JobWorker> progressMultiInstanceTasks() {
        JobHandler handler = (c, j) -> {
            if (ThreadLocalRandom.current().nextBoolean()) {
                c.newCompleteCommand(j.getKey()).send().join();
            } else {
                c.newFailCommand(j.getKey()).retries(0).send().join();
            }
        };
        ArrayList<JobWorker> workers = new ArrayList<JobWorker>();
        workers.add(this.client.newWorker().jobType("filter").handler(handler).open());
        workers.add(this.client.newWorker().jobType("map").handler(handler).open());
        workers.add(this.client.newWorker().jobType("reduce").handler(handler).open());
        return workers;
    }

    private void cancelSomeInstances() {
        Iterator<Long> iterator = this.processInstanceKeys.iterator();
        while (iterator.hasNext()) {
            long processInstanceKey = iterator.next();
            if (ThreadLocalRandom.current().nextInt(15) == 1) {
                try {
                    this.client.newCancelInstanceCommand(processInstanceKey).send().join();
                }
                catch (ClientException ex) {
                    LOGGER.error("Error occurred when cancelling process instance:", (Throwable)ex);
                }
            }
            iterator.remove();
        }
    }

    protected void createOperations() {
    }

    protected JobWorker progressOrderProcessCheckPayment() {
        return this.client.newWorker().jobType("checkPayment").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenario = ThreadLocalRandom.current().nextInt(5);
            switch (scenario) {
                case 0: {
                    throw new RuntimeException("Payment system not available.");
                }
                case 1: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"paid\":false}").send().join();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"paid\":true,\"orderStatus\": \"PAID\"}").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressOrderProcessCheckItems() {
        return this.client.newWorker().jobType("checkItems").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenario = ThreadLocalRandom.current().nextInt(4);
            switch (scenario) {
                case 0: 
                case 1: 
                case 2: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"smthIsMissing\":false,\"orderStatus\":\"AWAITING_SHIPMENT\"}").send().join();
                    break;
                }
                case 3: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"smthIsMissing\":true}").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressOrderProcessShipArticles() {
        return this.client.newWorker().jobType("shipArticles").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenario = ThreadLocalRandom.current().nextInt(2);
            switch (scenario) {
                case 0: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"orderStatus\":\"SHIPPED\"}").send().join();
                    break;
                }
                case 1: {
                    jobClient.newFailCommand(job.getKey()).retries(0).errorMessage("Cannot connect to server delivery05").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressFlightRegistrationRegisterCabinBag() {
        return this.client.newWorker().jobType("registerCabinBag").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenario = ThreadLocalRandom.current().nextInt(4);
            switch (scenario) {
                case 0: 
                case 1: 
                case 2: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"luggage\":false}").send().join();
                    break;
                }
                case 3: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"luggage\":true}").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressFlightRegistrationDetermineWeight() {
        return this.client.newWorker().jobType("determineLuggageWeight").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            jobClient.newCompleteCommand(job.getKey()).variables("{\"luggageWeight\":" + (ThreadLocalRandom.current().nextInt(10) + 20) + "}").send().join();
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressReviewLoanRequestTask() {
        return this.client.newWorker().jobType("reviewLoanRequest").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenarioCount = ThreadLocalRandom.current().nextInt(3);
            switch (scenarioCount) {
                case 0: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"loanRequestOK\": " + ThreadLocalRandom.current().nextBoolean() + "}").send().join();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    jobClient.newFailCommand(job.getKey()).retries(1).errorMessage("Loan request does not contain all the required data").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressCheckSchufaTask() {
        return this.client.newWorker().jobType("checkSchufa").handler((jobClient, job) -> {
            if (!this.canProgress(job.getProcessInstanceKey())) {
                return;
            }
            int scenarioCount = ThreadLocalRandom.current().nextInt(3);
            switch (scenarioCount) {
                case 0: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"schufaOK\": " + ThreadLocalRandom.current().nextBoolean() + "}").send().join();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    jobClient.newFailCommand(job.getKey()).retries(0).errorMessage("Schufa system is not accessible").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private boolean canProgress(long key) {
        return !this.doNotTouchProcessInstanceKeys.contains(key);
    }

    protected void createProcessWithoutInstances() {
        Long processDefinitionKeyVersion1 = ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/withoutInstancesProcess_v_1.bpmn"});
        Long processDefinitionKeyVersion2 = ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/withoutInstancesProcess_v_2.bpmn"});
        LOGGER.info("Created process 'withoutInstancesProcess' version 1: {} and version 2: {}", (Object)processDefinitionKeyVersion1, (Object)processDefinitionKeyVersion2);
    }

    protected void createProcessWithInstancesThatHasOnlyIncidents(int forVersion1, int forVersion2) {
        Long processInstanceKey;
        int i;
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/onlyIncidentsProcess_v_1.bpmn"});
        for (i = 0; i < forVersion1; ++i) {
            processInstanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"onlyIncidentsProcess", null);
            this.failTask(processInstanceKey, "alwaysFails", "No memory left.");
        }
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/onlyIncidentsProcess_v_2.bpmn"});
        for (i = 0; i < forVersion2; ++i) {
            processInstanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"onlyIncidentsProcess", null);
            this.failTask(processInstanceKey, "alwaysFails", "No space left on device.");
            this.failTask(processInstanceKey, "alwaysFails2", "No space left on device.");
        }
        LOGGER.info("Created process 'onlyIncidentsProcess' with {} instances for version 1 and {} instances for version 2", (Object)forVersion1, (Object)forVersion2);
    }

    protected void createProcessWithInstancesWithoutIncidents(int forVersion1, int forVersion2) {
        int i;
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/withoutIncidentsProcess_v_1.bpmn"});
        for (i = 0; i < forVersion1; ++i) {
            ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"withoutIncidentsProcess", null);
        }
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/withoutIncidentsProcess_v_2.bpmn"});
        for (i = 0; i < forVersion2; ++i) {
            Long processInstanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"withoutIncidentsProcess", null);
            this.completeTask(processInstanceKey, "neverFails", null);
        }
        LOGGER.info("Created process 'withoutIncidentsProcess' with {} instances for version 1 and {} instances for version 2", (Object)forVersion1, (Object)forVersion2);
    }

    protected void deployVersion1() {
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String[])new String[]{"usertest/orderProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String[])new String[]{"usertest/loanProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String[])new String[]{"usertest/registerPassenger_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/multiInstance_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/manual-task.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/intermediate-message-throw-event.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/intermediate-none-event.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/message-end-event.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/invoice.bpmn"});
    }

    protected void startProcessInstances(int version) {
        int instancesCount = ThreadLocalRandom.current().nextInt(15) + 15;
        for (int i = 0; i < instancesCount; ++i) {
            this.processInstanceKeys.add(this.startDMNInvoice());
            if (version < 2) {
                this.processInstanceKeys.add(this.startLoanProcess());
                this.processInstanceKeys.add(this.startManualProcess());
                this.processInstanceKeys.add(this.startIntermediateMessageThrowEventProcess());
                this.processInstanceKeys.add(this.startIntermediateNoneEventProcess());
                this.processInstanceKeys.add(this.startMessageEndEventProcess());
            }
            if (version >= 3) continue;
            this.processInstanceKeys.add(this.startOrderProcess());
            this.processInstanceKeys.add(this.startFlightRegistrationProcess());
            this.processInstanceKeys.add(this.startMultiInstanceProcess());
        }
    }

    private long startFlightRegistrationProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String)"flightRegistration", (String)("{\n  \"firstName\": \"" + NameGenerator.getRandomFirstName() + "\",\n  \"lastName\": \"" + NameGenerator.getRandomLastName() + "\",\n  \"passNo\": \"PS" + (ThreadLocalRandom.current().nextInt(1000000) + (ThreadLocalRandom.current().nextInt(9) + 1) * 1000000) + "\",\n  \"ticketNo\": \"" + ThreadLocalRandom.current().nextInt(1000) + "\"\n}"));
    }

    private long startOrderProcess() {
        float price1 = Math.round(ThreadLocalRandom.current().nextFloat() * 100000.0f) / 100;
        float price2 = Math.round(ThreadLocalRandom.current().nextFloat() * 10000.0f) / 100;
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)"<default>", (String)"orderProcess", (String)("{\n  \"clientNo\": \"CNT-1211132-02\",\n  \"orderNo\": \"CMD0001-01\",\n  \"items\": [\n    {\n      \"code\": \"123.135.625\",\n      \"name\": \"Laptop Lenovo ABC-001\",\n      \"quantity\": 1,\n      \"price\": " + Double.valueOf(price1) + "\n    },\n    {\n      \"code\": \"111.653.365\",\n      \"name\": \"Headset Sony QWE-23\",\n      \"quantity\": 2,\n      \"price\": " + Double.valueOf(price2) + "\n    }\n  ],\n  \"mwst\": " + Double.valueOf((double)(price1 + price2) * 0.19) + ",\n  \"total\": " + Double.valueOf(price1 + price2) + ",\n  \"orderStatus\": \"NEW\"\n}"));
    }

    private long startLoanProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String)"loanProcess", (String)("{\"requestId\": \"RDG123000001\",\n  \"amount\": " + (ThreadLocalRandom.current().nextInt(10000) + 20000) + ",\n  \"applier\": {\n    \"firstname\": \"Max\",\n    \"lastname\": \"Muster\",\n    \"age\": " + (ThreadLocalRandom.current().nextInt(30) + 18) + "\n  },\n  \"newClient\": false,\n  \"previousRequestIds\": [\"RDG122000001\", \"RDG122000501\", \"RDG122000057\"],\n  \"attachedDocs\": [\n    {\n      \"docType\": \"ID\",\n      \"number\": 123456789\n    },\n    {\n      \"docType\": \"APPLICATION_FORM\",\n      \"number\": 321547\n    }\n  ],\n  \"otherInfo\": null\n}"));
    }

    private long startDMNInvoice() {
        String[] invoiceCategories = new String[]{"Misc", "Travel Expenses", "Software License Costs"};
        if (ThreadLocalRandom.current().nextInt(3) > 0) {
            return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"invoice", (String)("{\"amount\": " + ThreadLocalRandom.current().nextInt(1200) + ",\n  \"invoiceCategory\": \"" + invoiceCategories[ThreadLocalRandom.current().nextInt(3)] + "\"\n}"));
        }
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"invoice", null);
    }

    private long startManualProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"manual-task-process", null);
    }

    private Long startIntermediateNoneEventProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"intermediate-none-event-process", null);
    }

    private Long startIntermediateMessageThrowEventProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"intermediate-message-throw-event-process", null);
    }

    private Long startMessageEndEventProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"message-end-event-process", null);
    }

    private long startMultiInstanceProcess() {
        return ZeebeTestUtil.startProcessInstance((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String)"multiInstanceProcess", (String)"{\"items\": [1, 2, 3]}");
    }

    protected void deployVersion2() {
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String[])new String[]{"usertest/orderProcess_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant("<default>"), (String[])new String[]{"usertest/registerPassenger_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/multiInstance_v_2.bpmn"});
        ZeebeTestUtil.deployDecision((CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/invoiceBusinessDecisions_v_1.dmn"});
    }

    protected void deployVersion3() {
        ZeebeTestUtil.deployDecision((CamundaClient)this.client, (String)this.getTenant(TENANT_B), (String[])new String[]{"usertest/invoiceBusinessDecisions_v_2.dmn"});
    }

    protected void deployVersion4() {
    }

    private static class CompleteJobHandler
    implements JobHandler {
        private final String payload;
        private final long processInstanceKey;
        private boolean taskCompleted = false;

        public CompleteJobHandler(String payload, long processInstanceKey) {
            this.payload = payload;
            this.processInstanceKey = processInstanceKey;
        }

        public void handle(JobClient jobClient, ActivatedJob job) {
            if (!this.taskCompleted && this.processInstanceKey == job.getProcessInstanceKey()) {
                if (this.payload == null) {
                    jobClient.newCompleteCommand(job.getKey()).variables(job.getVariables()).send().join();
                } else {
                    jobClient.newCompleteCommand(job.getKey()).variables(this.payload).send().join();
                }
                this.taskCompleted = true;
            }
        }

        public boolean isTaskCompleted() {
            return this.taskCompleted;
        }
    }

    private static class FailJobHandler
    implements JobHandler {
        private final long processInstanceKey;
        private final String errorMessage;
        private boolean taskFailed = false;

        public FailJobHandler(long processInstanceKey, String errorMessage) {
            this.processInstanceKey = processInstanceKey;
            this.errorMessage = errorMessage;
        }

        public void handle(JobClient jobClient, ActivatedJob job) {
            if (!this.taskFailed && this.processInstanceKey == job.getProcessInstanceKey()) {
                FailJobCommandStep1.FailJobCommandStep2 failCmd = jobClient.newFailCommand(job.getKey()).retries(0);
                if (this.errorMessage != null) {
                    failCmd = failCmd.errorMessage(this.errorMessage);
                }
                failCmd.send().join();
                this.taskFailed = true;
            }
        }

        public boolean isTaskFailed() {
            return this.taskFailed;
        }
    }
}

