/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.data;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.worker.JobWorker;
import io.camunda.operate.data.DataGenerator;
import io.camunda.operate.store.ZeebeStore;
import io.camunda.operate.util.ThreadUtil;
import io.camunda.security.configuration.SecurityConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"searchEngineSchemaInitializer"})
public abstract class AbstractDataGenerator
implements DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataGenerator.class);
    @Autowired
    @Qualifier(value="camundaClient")
    protected CamundaClient client;
    protected boolean manuallyCalled = false;
    protected ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    @Autowired
    private SecurityConfiguration securityConfiguration;
    private boolean shutdown = false;
    @Autowired
    private ZeebeStore zeebeStore;

    @PostConstruct
    private void startDataGenerator() {
        this.startGeneratingData();
    }

    protected void startGeneratingData() {
        LOGGER.debug("INIT: Generate demo data...");
        try {
            this.createZeebeDataAsync(false);
        }
        catch (Exception ex) {
            LOGGER.debug("Demo data could not be generated. Cause: {}", (Object)ex.getMessage());
            LOGGER.error("Error occurred when generating demo data.", (Throwable)ex);
        }
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Shutdown DataGenerator");
        this.shutdown = true;
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
            }
        }
    }

    @Override
    public void createZeebeDataAsync(boolean manuallyCalled) {
        this.scheduler.execute(() -> {
            Boolean zeebeDataCreated = null;
            while (zeebeDataCreated == null && !this.shutdown) {
                try {
                    zeebeDataCreated = this.createZeebeData(manuallyCalled);
                }
                catch (Exception ex) {
                    LOGGER.error(String.format("Error occurred when creating demo data: %s. Retrying...", ex.getMessage()), (Throwable)ex);
                    ThreadUtil.sleepFor((long)2000L);
                }
            }
        });
    }

    public boolean createZeebeData(boolean manuallyCalled) {
        this.manuallyCalled = manuallyCalled;
        return this.shouldCreateData(manuallyCalled);
    }

    public boolean shouldCreateData(boolean manuallyCalled) {
        String zeebeIndexPrefix;
        boolean exists;
        if (!manuallyCalled && (exists = this.zeebeStore.zeebeIndicesExists((zeebeIndexPrefix = this.zeebeStore.getZeebeIndexPrefix()) + "*deployment*"))) {
            LOGGER.debug("Data already exists in Zeebe.");
            return false;
        }
        return true;
    }

    protected JobWorker progressSimpleTask(String taskType) {
        return this.client.newWorker().jobType(taskType).handler((jobClient, job) -> {
            int scenarioCount = ThreadLocalRandom.current().nextInt(3);
            switch (scenarioCount) {
                case 0: {
                    break;
                }
                case 1: {
                    jobClient.newCompleteCommand(job.getKey()).send().join();
                    break;
                }
                case 2: {
                    jobClient.newFailCommand(job.getKey()).retries(0).send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    protected JobWorker progressSimpleTask(String taskType, int retriesLeft) {
        return this.client.newWorker().jobType(taskType).handler((jobClient, job) -> jobClient.newFailCommand(job.getKey()).retries(retriesLeft).send().join()).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    protected String getTenant(String tenantId) {
        if (this.securityConfiguration.getMultiTenancy().isChecksEnabled()) {
            return tenantId;
        }
        return "<default>";
    }
}

