/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.data.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.DecisionStore;
import io.camunda.operate.util.PayloadUtil;
import io.camunda.webapps.schema.descriptors.operate.index.DecisionIndex;
import io.camunda.webapps.schema.descriptors.operate.index.DecisionRequirementsIndex;
import io.camunda.webapps.schema.descriptors.operate.template.DecisionInstanceTemplate;
import io.camunda.webapps.schema.entities.ExporterEntity;
import io.camunda.webapps.schema.entities.operate.dmn.DecisionInstanceEntity;
import io.camunda.webapps.schema.entities.operate.dmn.DecisionInstanceInputEntity;
import io.camunda.webapps.schema.entities.operate.dmn.DecisionInstanceOutputEntity;
import io.camunda.webapps.schema.entities.operate.dmn.DecisionInstanceState;
import io.camunda.webapps.schema.entities.operate.dmn.DecisionType;
import io.camunda.webapps.schema.entities.operate.dmn.definition.DecisionDefinitionEntity;
import io.camunda.webapps.schema.entities.operate.dmn.definition.DecisionRequirementsEntity;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DecisionDataUtil {
    public static final String DECISION_INSTANCE_ID_1_1 = "12121212-1";
    public static final String DECISION_INSTANCE_ID_1_2 = "12121212-2";
    public static final String DECISION_INSTANCE_ID_1_3 = "12121212-3";
    public static final String DECISION_INSTANCE_ID_2_1 = "13131313-1";
    public static final String DECISION_INSTANCE_ID_2_2 = "13131313-2";
    public static final String DECISION_DEFINITION_ID_1 = "decisionDef1";
    public static final String DECISION_DEFINITION_ID_2 = "decisionDef2";
    public static final long PROCESS_INSTANCE_ID = 555555L;
    public static final String DECISION_DEFINITION_NAME_1 = "Assign Approver Group";
    public static final String DECISION_ID_1 = "invoice-assign-approver";
    public static final String DECISION_ID_2 = "invoiceClassification";
    public static final String TENANT1 = "tenant1";
    public static final String TENANT2 = "tenant2";
    @Autowired
    protected DecisionStore decisionStore;
    private Map<Class<? extends ExporterEntity>, String> entityToESAliasMap;
    private final Random random = new Random();
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private PayloadUtil payloadUtil;

    public List<ExporterEntity> createDecisionDefinitions() {
        ArrayList<ExporterEntity> decisionEntities = new ArrayList<ExporterEntity>();
        decisionEntities.add((ExporterEntity)((DecisionRequirementsEntity)((DecisionRequirementsEntity)new DecisionRequirementsEntity().setId("1111")).setKey(1111L)).setDecisionRequirementsId("invoiceBusinessDecisions").setName("Invoice Business Decisions").setVersion(1).setXml(this.payloadUtil.readStringFromClasspath("/usertest/invoiceBusinessDecisions_v_1.dmn")).setResourceName("invoiceBusinessDecisions_v_1.dmn"));
        decisionEntities.add((ExporterEntity)((DecisionDefinitionEntity)((DecisionDefinitionEntity)new DecisionDefinitionEntity().setId("1222")).setKey(1222L)).setDecisionId(DECISION_ID_2).setName("Invoice Classification").setVersion(1).setDecisionRequirementsId("invoiceBusinessDecisions").setDecisionRequirementsKey(1111L));
        decisionEntities.add((ExporterEntity)((DecisionDefinitionEntity)((DecisionDefinitionEntity)new DecisionDefinitionEntity().setId("1333")).setKey(1333L)).setDecisionId(DECISION_ID_1).setName(DECISION_DEFINITION_NAME_1).setVersion(1).setDecisionRequirementsId("invoiceBusinessDecisions").setDecisionRequirementsKey(1111L));
        decisionEntities.add((ExporterEntity)((DecisionRequirementsEntity)((DecisionRequirementsEntity)new DecisionRequirementsEntity().setId("2222")).setKey(2222L)).setDecisionRequirementsId("invoiceBusinessDecisions").setName("Invoice Business Decisions").setVersion(2).setXml(this.payloadUtil.readStringFromClasspath("/usertest/invoiceBusinessDecisions_v_2.dmn")).setResourceName("invoiceBusinessDecisions_v_2.dmn"));
        decisionEntities.add((ExporterEntity)((DecisionDefinitionEntity)((DecisionDefinitionEntity)new DecisionDefinitionEntity().setId("2222")).setKey(2222L)).setDecisionId(DECISION_ID_2).setName("Invoice Classification").setVersion(2).setDecisionRequirementsId("invoiceBusinessDecisions").setDecisionRequirementsKey(2222L));
        decisionEntities.add((ExporterEntity)((DecisionDefinitionEntity)((DecisionDefinitionEntity)new DecisionDefinitionEntity().setId("2333")).setKey(2333L)).setDecisionId(DECISION_ID_1).setName(DECISION_DEFINITION_NAME_1).setVersion(2).setDecisionRequirementsId("invoiceBusinessDecisions").setDecisionRequirementsKey(2222L));
        return decisionEntities;
    }

    public List<DecisionInstanceEntity> createDecisionInstances() {
        ArrayList<DecisionInstanceEntity> result = new ArrayList<DecisionInstanceEntity>();
        result.add(this.createDecisionInstance(DECISION_INSTANCE_ID_1_1, DecisionInstanceState.EVALUATED, DECISION_DEFINITION_NAME_1, OffsetDateTime.now(), DECISION_DEFINITION_ID_1, 1, DECISION_ID_1, 35467L, 555555L, TENANT1));
        result.add(this.createDecisionInstance(DECISION_INSTANCE_ID_1_2, DecisionInstanceState.EVALUATED, "Invoice Classification", OffsetDateTime.now(), DECISION_DEFINITION_ID_2, 1, DECISION_ID_2, 35467L, this.random.nextInt(1000), TENANT2));
        result.add(this.createDecisionInstance(DECISION_INSTANCE_ID_1_3, DecisionInstanceState.EVALUATED, "Invoice Classification", OffsetDateTime.now(), DECISION_DEFINITION_ID_2, 2, DECISION_ID_2, 35467L, this.random.nextInt(1000), TENANT1));
        result.add(this.createDecisionInstance(DECISION_INSTANCE_ID_2_1, DecisionInstanceState.FAILED, DECISION_DEFINITION_NAME_1, OffsetDateTime.now(), DECISION_DEFINITION_ID_1, 1, DECISION_ID_1, 35467L, 555555L, TENANT2));
        result.add(this.createDecisionInstance(DECISION_INSTANCE_ID_2_2, DecisionInstanceState.FAILED, "Invoice Classification", OffsetDateTime.now(), DECISION_DEFINITION_ID_2, 2, DECISION_ID_2, 35467L, this.random.nextInt(1000), TENANT1));
        return result;
    }

    public DecisionInstanceEntity createDecisionInstance(OffsetDateTime evaluationDate) {
        return this.createDecisionInstance(this.random.nextInt(1) == 0 ? DecisionInstanceState.EVALUATED : DecisionInstanceState.FAILED, UUID.randomUUID().toString(), evaluationDate, this.random.nextInt(1) == 0 ? DECISION_DEFINITION_ID_1 : DECISION_DEFINITION_ID_2, 1, UUID.randomUUID().toString(), this.random.nextInt(1000), this.random.nextInt(1000));
    }

    public DecisionInstanceEntity createDecisionInstance(DecisionInstanceState state, String decisionName, OffsetDateTime evaluationDate, String decisionDefinitionId, int decisionVersion, String decisionId, long processDefinitionKey, long processInstanceKey) {
        return this.createDecisionInstance(String.valueOf(this.random.nextInt(1000)) + "-1", state, decisionName, evaluationDate, decisionDefinitionId, decisionVersion, decisionId, processDefinitionKey, processInstanceKey, null);
    }

    private DecisionInstanceEntity createDecisionInstance(String decisionInstanceId, DecisionInstanceState state, String decisionName, OffsetDateTime evaluationDate, String decisionDefinitionId, int decisionVersion, String decisionId, long processDefinitionKey, long processInstanceKey, String tenantId) {
        ArrayList<DecisionInstanceInputEntity> inputs = new ArrayList<DecisionInstanceInputEntity>();
        inputs.add(new DecisionInstanceInputEntity().setId("InputClause_0og2hn3").setName("Invoice Classification").setValue("day-to-day expense"));
        inputs.add(new DecisionInstanceInputEntity().setId("InputClause_0og2hn3").setName("Invoice Classification").setValue("budget"));
        ArrayList<DecisionInstanceOutputEntity> outputs = new ArrayList<DecisionInstanceOutputEntity>();
        outputs.add(new DecisionInstanceOutputEntity().setId("OutputClause_1cthd0w").setName("Approver Group").setValue("budget").setRuleIndex(2).setRuleId("row-49839158-5"));
        outputs.add(new DecisionInstanceOutputEntity().setId("OutputClause_1cthd0w").setName("Approver Group").setValue("sales").setRuleIndex(1).setRuleId("row-49839158-6"));
        outputs.add(new DecisionInstanceOutputEntity().setId("OutputClause_1cthd0w").setName("Approver Group").setValue("accounting").setRuleIndex(1).setRuleId("row-49839158-1"));
        String evaluationFailure = null;
        if (state == DecisionInstanceState.FAILED) {
            evaluationFailure = "Variable not found: invoiceClassification";
        }
        return ((DecisionInstanceEntity)((DecisionInstanceEntity)new DecisionInstanceEntity().setId(decisionInstanceId)).setKey(Long.valueOf(decisionInstanceId.split("-")[0]).longValue())).setExecutionIndex(Integer.valueOf(decisionInstanceId.split("-")[1])).setState(state).setEvaluationFailure(evaluationFailure).setDecisionName(decisionName).setDecisionVersion(decisionVersion).setDecisionType(DecisionType.DECISION_TABLE).setEvaluationDate(evaluationDate).setDecisionDefinitionId(decisionDefinitionId).setDecisionId(decisionId).setDecisionRequirementsId("1111").setDecisionRequirementsKey(1111L).setElementId("taskA").setElementInstanceKey(76543L).setEvaluatedInputs(inputs).setEvaluatedOutputs(outputs).setPosition(Long.valueOf(1000L)).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey).setResult("{\"total\": 100.0}").setTenantId(tenantId);
    }

    public void persistOperateEntities(List<? extends ExporterEntity> operateEntities) throws PersistenceException {
        try {
            BatchRequest batchRequest = this.decisionStore.newBatchRequest();
            for (ExporterEntity exporterEntity : operateEntities) {
                String alias = this.getEntityToESAliasMap().get(exporterEntity.getClass());
                if (alias == null) {
                    throw new RuntimeException("Index not configured for " + exporterEntity.getClass().getName());
                }
                batchRequest.add(alias, exporterEntity);
            }
            batchRequest.execute();
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public Map<Class<? extends ExporterEntity>, String> getEntityToESAliasMap() {
        if (this.entityToESAliasMap == null) {
            this.entityToESAliasMap = new HashMap<Class<? extends ExporterEntity>, String>();
            this.entityToESAliasMap.put(DecisionInstanceEntity.class, this.decisionInstanceTemplate.getFullQualifiedName());
            this.entityToESAliasMap.put(DecisionRequirementsEntity.class, this.decisionRequirementsIndex.getFullQualifiedName());
            this.entityToESAliasMap.put(DecisionDefinitionEntity.class, this.decisionIndex.getFullQualifiedName());
        }
        return this.entityToESAliasMap;
    }
}

