/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.data.develop;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.operate.data.usertest.UserTestDataGenerator;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.util.ZeebeTestUtil;
import io.camunda.operate.util.rest.StatefulRestTemplate;
import io.camunda.webapps.schema.entities.operation.OperationType;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobWorker;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="dataGenerator")
@Profile(value={"dev-data"})
public class DevelopDataGenerator
extends UserTestDataGenerator {
    private static final String OPERATE_HOST = "localhost";
    private static final int OPERATE_PORT = 8080;
    private static final String OPERATE_USER = "demo";
    private static final String OPERATE_PASSWORD = "demo";
    private static final String TENANT_A = "tenantA";
    private final List<Long> processInstanceKeys = new ArrayList<Long>();
    @Autowired
    private BiFunction<String, Integer, StatefulRestTemplate> statefulRestTemplateFactory;
    private StatefulRestTemplate restTemplate;

    @Override
    protected void startGeneratingData() {
        this.restTemplate = this.statefulRestTemplateFactory.apply(OPERATE_HOST, 8080);
        super.startGeneratingData();
    }

    @Override
    public void createSpecialDataV1() {
        ThreadLocalRandom.current();
        int orderId = ThreadLocalRandom.current().nextInt(10);
        long instanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"interruptingBoundaryEvent", (String)("{\"orderId\": \"" + orderId + "\"\n}"));
        this.doNotTouchProcessInstanceKeys.add(instanceKey);
        this.sendMessages("interruptTask1", "{\"messageVar\": \"someValue\"\n}", 1, String.valueOf(orderId));
        ThreadLocalRandom.current();
        orderId = ThreadLocalRandom.current().nextInt(10);
        instanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"interruptingBoundaryEvent", (String)("{\"orderId\": \"" + orderId + "\"\n}"));
        this.doNotTouchProcessInstanceKeys.add(instanceKey);
        this.sendMessages("interruptTask1", "{\"messageVar\": \"someValue\"\n}", 1, String.valueOf(orderId));
        this.completeTask(instanceKey, "task2", null);
        ThreadLocalRandom.current();
        orderId = ThreadLocalRandom.current().nextInt(10);
        instanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"nonInterruptingBoundaryEvent", (String)("{\"orderId\": \"" + orderId + "\"\n}"));
        this.doNotTouchProcessInstanceKeys.add(instanceKey);
        this.sendMessages("messageTask1", "{\"messageVar\": \"someValue\"\n}", 1, String.valueOf(orderId));
        ThreadLocalRandom.current();
        orderId = ThreadLocalRandom.current().nextInt(10);
        instanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"nonInterruptingBoundaryEvent", (String)("{\"orderId\": \"" + orderId + "\"\n}"));
        this.doNotTouchProcessInstanceKeys.add(instanceKey);
        this.sendMessages("messageTask1", "{\"messageVar\": \"someValue\"\n}", 1, String.valueOf(orderId));
        this.failTask(instanceKey, "task1", "error");
        ThreadLocalRandom.current();
        orderId = ThreadLocalRandom.current().nextInt(10);
        instanceKey = ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"nonInterruptingBoundaryEvent", (String)("{\"orderId\": \"" + orderId + "\"\n}"));
        this.doNotTouchProcessInstanceKeys.add(instanceKey);
        this.sendMessages("messageTask1", "{\"messageVar\": \"someValue\"\n}", 1, String.valueOf(orderId));
        this.completeTask(instanceKey, "task1", null);
    }

    @Override
    protected void progressProcessInstances() {
        super.progressProcessInstances();
        this.jobWorkers.add(this.progressSimpleTask("upperTask"));
        this.jobWorkers.add(this.progressSimpleTask("lowerTask", 1));
        this.jobWorkers.add(this.progressSimpleTask("subprocessTask"));
        this.jobWorkers.add(this.progressSimpleTask("messageTask"));
        this.jobWorkers.add(this.progressSimpleTask("afterMessageTask"));
        this.jobWorkers.add(this.progressSimpleTask("messageTaskInterrupted"));
        this.jobWorkers.add(this.progressSimpleTask("timerTask"));
        this.jobWorkers.add(this.progressSimpleTask("afterTimerTask"));
        this.jobWorkers.add(this.progressSimpleTask("timerTaskInterrupted"));
        this.jobWorkers.add(this.progressSimpleTask("lastTask"));
        this.jobWorkers.add(this.progressSimpleTask("task1"));
        this.jobWorkers.add(this.progressSimpleTask("task2"));
        this.jobWorkers.add(this.progressSimpleTask("called-task"));
        this.jobWorkers.add(this.progressSimpleTask("parentProcessTask"));
        this.jobWorkers.add(this.progressSimpleTask("subprocessTask"));
        this.jobWorkers.add(this.progressSimpleTask("subSubprocessTask"));
        this.jobWorkers.add(this.progressSimpleTask("eventSupbprocessTask"));
        this.jobWorkers.add(this.progressBigProcessTaskA());
        this.jobWorkers.add(this.progressBigProcessTaskB());
        this.jobWorkers.add(this.progressErrorTask());
        this.jobWorkers.add(this.progressRetryTask());
        this.jobWorkers.add(this.progressPlaceOrderTask());
        this.sendMessages("clientMessage", "{\"messageVar\": \"someValue\"}", 20);
        this.sendMessages("interruptMessageTask", "{\"messageVar2\": \"someValue2\"}", 20);
        this.sendMessages("dataReceived", "{\"messageVar3\": \"someValue3\"}", 20);
    }

    @Override
    protected void createOperations() {
        this.restTemplate.loginWhenNeeded("demo", "demo");
        int operationsCount = ThreadLocalRandom.current().nextInt(20) + 90;
        for (int i = 0; i < operationsCount; ++i) {
            int no = ThreadLocalRandom.current().nextInt(operationsCount);
            Long processInstanceKey = this.processInstanceKeys.get(no);
            OperationType type = this.getType(i);
            Map<String, Object> request = this.getCreateBatchOperationRequestBody(processInstanceKey, type);
            RequestEntity requestEntity = RequestEntity.method((HttpMethod)HttpMethod.POST, (URI)this.restTemplate.getURL("/api/process-instances/batch-operation")).contentType(MediaType.APPLICATION_JSON).body(request);
            ResponseEntity response = this.restTemplate.exchange(requestEntity, String.class);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) continue;
            throw new OperateRuntimeException(String.format("Unable to create operations. REST response: %s", response));
        }
    }

    @Override
    protected JobWorker progressOrderProcessCheckPayment() {
        return this.client.newWorker().jobType("checkPayment").handler((jobClient, job) -> {
            int scenario = ThreadLocalRandom.current().nextInt(6);
            switch (scenario) {
                case 0: {
                    throw new RuntimeException("Payment system not available.");
                }
                case 1: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"paid\":false}").send().join();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"paid\":true}").send().join();
                    break;
                }
                case 5: {
                    jobClient.newCompleteCommand(job.getKey()).send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    @Override
    protected void deployVersion1() {
        super.deployVersion1();
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/complexProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/eventBasedGatewayProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/subProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/interruptingBoundaryEvent_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/nonInterruptingBoundaryEvent_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/timerProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/callActivityProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/eventSubProcess_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/bigProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/errorProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/error-end-event.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/terminateEndEvent.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/undefined-task.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/dataStore.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/linkEvents.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/escalationEvents_v_1.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/signalEvent.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/collapsedSubProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/compensationEvents.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/executionListeners.bpmn"});
    }

    @Override
    protected void startProcessInstances(int version) {
        super.startProcessInstances(version);
        if (version == 1) {
            this.createBigProcess(40, 1000);
        }
        int instancesCount = ThreadLocalRandom.current().nextInt(15) + 15;
        for (int i = 0; i < instancesCount; ++i) {
            if (version == 1) {
                this.sendMessages("newClientMessage", "{\"clientId\": \"" + ThreadLocalRandom.current().nextInt(10) + "\"\n}", 1);
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"call-activity-process", (String)("{\"var\": " + ThreadLocalRandom.current().nextInt(10) + "}")));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"eventSubprocessProcess", (String)("{\"clientId\": \"" + ThreadLocalRandom.current().nextInt(10) + "\"}")));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"errorProcess", (String)"{\"errorCode\": \"boundary\"}"));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"errorProcess", (String)"{\"errorCode\": \"subProcess\"}"));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"errorProcess", (String)"{\"errorCode\": \"unknown\"}"));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"error-end-process", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"terminateEndEvent", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"collapsedSubProcess", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"dataStoreProcess", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"linkEventProcess", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"escalationEvents", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"undefined-task-process", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"compensationEvents", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"executionListeners", null));
            }
            if (version == 2) {
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"interruptingBoundaryEvent", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"nonInterruptingBoundaryEvent", null));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"call-activity-process", (String)("{\"var\": " + ThreadLocalRandom.current().nextInt(10) + "}")));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"escalationEvents", null));
            }
            if (version < 2) {
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"prWithSubprocess", null));
            }
            if (version < 3) {
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"complexProcess", (String)("{\"clientId\": \"" + ThreadLocalRandom.current().nextInt(10) + "\"}")));
            }
            if (version == 3) {
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"complexProcess", (String)("{\"goUp\": " + ThreadLocalRandom.current().nextInt(5) + "}")));
                this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"call-activity-process", (String)("{\"orders\": [" + ThreadLocalRandom.current().nextInt(10) + ", " + ThreadLocalRandom.current().nextInt(10) + "]}")));
            }
            if (version != 4) continue;
            this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"processAnnualLeave", (String)("{\"leave_type\":\"fto\", \"days\":" + ThreadLocalRandom.current().nextInt(15) + "}")));
        }
        if (version == 1) {
            this.processInstanceKeys.add(ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"timerProcess", null));
        }
    }

    @Override
    protected void deployVersion2() {
        super.deployVersion2();
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/timerProcess_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/complexProcess_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/eventBasedGatewayProcess_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/interruptingBoundaryEvent_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/nonInterruptingBoundaryEvent_v_2.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/calledProcess.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/escalationEvents_v_2.bpmn"});
    }

    @Override
    protected void deployVersion3() {
        super.deployVersion3();
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/complexProcess_v_3.bpmn"});
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/calledProcess_v_2.bpmn"});
    }

    @Override
    protected void deployVersion4() {
        super.deployVersion4();
        ZeebeTestUtil.deployProcess((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String[])new String[]{"develop/user-task-annual-leave.bpmn"});
    }

    private Map<String, Object> getCreateBatchOperationRequestBody(Long processInstanceKey, OperationType type) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        HashMap<String, Object> listViewRequest = new HashMap<String, Object>();
        listViewRequest.put("running", true);
        listViewRequest.put("active", true);
        listViewRequest.put("ids", new Long[]{processInstanceKey});
        request.put("query", listViewRequest);
        request.put("operationType", type.toString());
        return request;
    }

    private OperationType getType(int i) {
        return i % 2 == 0 ? OperationType.CANCEL_PROCESS_INSTANCE : OperationType.RESOLVE_INCIDENT;
    }

    private void sendMessages(String messageName, String payload, int count, String correlationKey) {
        for (int i = 0; i < count; ++i) {
            this.client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).variables(payload).timeToLive(Duration.ofSeconds(30L)).messageId(UUID.randomUUID().toString()).send().join();
        }
    }

    private void sendMessages(String messageName, String payload, int count) {
        this.sendMessages(messageName, payload, count, String.valueOf(ThreadLocalRandom.current().nextInt(7)));
    }

    private JobWorker progressPlaceOrderTask() {
        return this.client.newWorker().jobType("placeOrder").handler((jobClient, job) -> {
            int shipping = ThreadLocalRandom.current().nextInt(5) - 1;
            jobClient.newCompleteCommand(job.getKey()).variables("{\"shipping\":" + shipping + "}").send().join();
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressTaskA() {
        return this.client.newWorker().jobType("taskA").handler((jobClient, job) -> {
            int scenarioCount = ThreadLocalRandom.current().nextInt(2);
            switch (scenarioCount) {
                case 0: {
                    jobClient.newCompleteCommand(job.getKey()).send().join();
                    break;
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressBigProcessTaskA() {
        return this.client.newWorker().jobType("bigProcessTaskA").handler((jobClient, job) -> {
            Map varMap;
            Integer i = (Integer)(varMap = job.getVariablesAsMap()).get("i");
            varMap.put("i", i == null ? 1 : i + 1);
            jobClient.newCompleteCommand(job.getKey()).variables(varMap).send().join();
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressBigProcessTaskB() {
        int[] countBeforeIncident = new int[]{0};
        return this.client.newWorker().jobType("bigProcessTaskB").handler((jobClient, job) -> {
            if (countBeforeIncident[0] <= 45) {
                jobClient.newCompleteCommand(job.getKey()).send().join();
                countBeforeIncident[0] = countBeforeIncident[0] + 1;
            } else {
                if (ThreadLocalRandom.current().nextBoolean()) {
                    jobClient.newFailCommand(job.getKey()).retries(0).send().join();
                } else {
                    jobClient.newCompleteCommand(job.getKey()).send().join();
                }
                countBeforeIncident[0] = 0;
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressErrorTask() {
        return this.client.newWorker().jobType("errorTask").handler((jobClient, job) -> {
            String errorCode = job.getVariablesAsMap().getOrDefault("errorCode", "error");
            jobClient.newThrowErrorCommand(job.getKey()).errorCode(errorCode).errorMessage("Job worker throw error with error code: " + errorCode).send().join();
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private JobWorker progressRetryTask() {
        return this.client.newWorker().jobType("retryTask").handler((jobClient, job) -> {
            int scenarioCount = ThreadLocalRandom.current().nextInt(4);
            switch (scenarioCount) {
                case 0: 
                case 1: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"retry\": true}").send().join();
                    break;
                }
                case 2: {
                    jobClient.newFailCommand(job.getKey()).retries(0).send().join();
                    break;
                }
                default: {
                    jobClient.newCompleteCommand(job.getKey()).variables("{\"retry\": false}").send().join();
                }
            }
        }).name("operate").timeout(Duration.ofSeconds(5L)).open();
    }

    private void createBigProcess(int loopCardinality, int numberOfClients) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode object = objectMapper.createObjectNode();
        object.put("loopCardinality", loopCardinality);
        ArrayNode arrayNode = object.putArray("clients");
        for (int j = 0; j <= numberOfClients; ++j) {
            arrayNode.add(j);
        }
        String jsonString = object.toString();
        ZeebeTestUtil.startProcessInstance((boolean)true, (ZeebeClient)this.client, (String)this.getTenant(TENANT_A), (String)"bigProcess", (String)jsonString);
    }

    public void setClient(ZeebeClient client) {
        this.client = client;
    }
}

