/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.property;

import io.camunda.operate.conditions.DatabaseType;
import io.camunda.operate.property.BackupProperties;
import io.camunda.operate.property.CloudProperties;
import io.camunda.operate.property.IdentityProperties;
import io.camunda.operate.property.ImportProperties;
import io.camunda.operate.property.OperateElasticsearchProperties;
import io.camunda.operate.property.OperateOpensearchProperties;
import io.camunda.operate.property.OperationExecutorProperties;
import io.camunda.operate.property.ZeebeProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class OperateProperties {
    public static final String PREFIX = "camunda.operate";
    public static final long BATCH_OPERATION_MAX_SIZE_DEFAULT = 1000000L;
    private static final String UNKNOWN_VERSION = "unknown-version";
    private boolean webappEnabled = true;
    private boolean rfc3339ApiDateFormat = false;
    private String password = "demo";
    private List<String> roles = List.of("OWNER");
    private Long batchOperationMaxSize = 1000000L;
    private boolean enterprise = false;
    private String tasklistUrl = null;
    @Value(value="${camunda.operate.internal.version.current}")
    private String version = "unknown-version";
    @NestedConfigurationProperty
    private OperateElasticsearchProperties elasticsearch = new OperateElasticsearchProperties();
    @NestedConfigurationProperty
    private OperateOpensearchProperties opensearch = new OperateOpensearchProperties();
    @NestedConfigurationProperty
    private ZeebeProperties zeebe = new ZeebeProperties();
    @NestedConfigurationProperty
    private OperationExecutorProperties operationExecutor = new OperationExecutorProperties();
    @NestedConfigurationProperty
    private ImportProperties importer = new ImportProperties();
    @NestedConfigurationProperty
    private IdentityProperties identity = new IdentityProperties();
    @NestedConfigurationProperty
    private CloudProperties cloud = new CloudProperties();
    @NestedConfigurationProperty
    private BackupProperties backup = new BackupProperties();
    private DatabaseType database = DatabaseType.Elasticsearch;

    public DatabaseType getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseType database) {
        this.database = database;
    }

    public boolean isElasticsearchDB() {
        return DatabaseType.Elasticsearch.equals((Object)this.database);
    }

    public boolean isWebappEnabled() {
        return this.webappEnabled;
    }

    public void setWebappEnabled(boolean webappEnabled) {
        this.webappEnabled = webappEnabled;
    }

    public Long getBatchOperationMaxSize() {
        return this.batchOperationMaxSize;
    }

    public void setBatchOperationMaxSize(Long batchOperationMaxSize) {
        this.batchOperationMaxSize = batchOperationMaxSize;
    }

    public OperateElasticsearchProperties getElasticsearch() {
        return this.elasticsearch;
    }

    public void setElasticsearch(OperateElasticsearchProperties elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    public OperateOpensearchProperties getOpensearch() {
        return this.opensearch;
    }

    public void setOpensearch(OperateOpensearchProperties opensearch) {
        this.opensearch = opensearch;
    }

    public ZeebeProperties getZeebe() {
        return this.zeebe;
    }

    public void setZeebe(ZeebeProperties zeebe) {
        this.zeebe = zeebe;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public OperationExecutorProperties getOperationExecutor() {
        return this.operationExecutor;
    }

    public void setOperationExecutor(OperationExecutorProperties operationExecutor) {
        this.operationExecutor = operationExecutor;
    }

    public ImportProperties getImporter() {
        return this.importer;
    }

    public void setImporter(ImportProperties importer) {
        this.importer = importer;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(boolean enterprise) {
        this.enterprise = enterprise;
    }

    public IdentityProperties getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityProperties identity) {
        this.identity = identity;
    }

    public CloudProperties getCloud() {
        return this.cloud;
    }

    public OperateProperties setCloud(CloudProperties cloud) {
        this.cloud = cloud;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public BackupProperties getBackup() {
        return this.backup;
    }

    public OperateProperties setBackup(BackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public String getTasklistUrl() {
        return this.tasklistUrl;
    }

    public void setTasklistUrl(String tasklistUrl) {
        this.tasklistUrl = tasklistUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public OperateProperties setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isRfc3339ApiDateFormat() {
        return this.rfc3339ApiDateFormat;
    }

    public void setRfc3339ApiDateFormat(boolean rfc3339ApiDateFormat) {
        this.rfc3339ApiDateFormat = rfc3339ApiDateFormat;
    }

    public String getIndexPrefix(DatabaseType databaseType) {
        return switch (databaseType) {
            case DatabaseType.Elasticsearch -> {
                if (this.getElasticsearch() == null) {
                    yield null;
                }
                yield this.getElasticsearch().getIndexPrefix();
            }
            case DatabaseType.Opensearch -> {
                if (this.getOpensearch() == null) {
                    yield null;
                }
                yield this.getOpensearch().getIndexPrefix();
            }
            default -> null;
        };
    }

    public String getIndexPrefix() {
        return this.getIndexPrefix(this.database);
    }
}

