/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

public interface NumberThrottleable {
    public void throttle();

    public void reset();

    public int get();

    public int getOriginal();

    public static class DivideNumberThrottle
    implements NumberThrottleable {
        private final int originalSize;
        private final int throttleFactor;
        private int changedSizeUsed;
        private int currentSize;

        public DivideNumberThrottle(int originalSize) {
            this(originalSize, 2);
        }

        public DivideNumberThrottle(int originalSize, int throttleFactor) {
            this.originalSize = originalSize;
            this.throttleFactor = throttleFactor;
            this.currentSize = originalSize;
        }

        @Override
        public void throttle() {
            this.changedSizeUsed = 0;
            this.currentSize /= this.throttleFactor;
            if (this.currentSize < 2) {
                this.currentSize = 1;
            }
        }

        @Override
        public void reset() {
            this.changedSizeUsed = 0;
            this.currentSize = this.originalSize;
        }

        @Override
        public int get() {
            if (this.currentSize < this.originalSize) {
                ++this.changedSizeUsed;
            }
            if (this.canSetToOriginalValue()) {
                this.reset();
            }
            return this.currentSize;
        }

        @Override
        public int getOriginal() {
            return this.originalSize;
        }

        private boolean canSetToOriginalValue() {
            return this.changedSizeUsed * this.currentSize * 2 > this.originalSize;
        }
    }
}

