/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.conditions;

import io.micrometer.common.util.StringUtils;
import java.util.Optional;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public abstract class DatabaseCondition
implements Condition {
    public static final String DATABASE_PROPERTY = "camunda.data.secondary-storage.type";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        String dbType = Optional.ofNullable(environment.getProperty(DATABASE_PROPERTY)).orElse("elasticsearch");
        return StringUtils.isEmpty((String)dbType) && this.getDefaultIfEmpty() || this.getDatabase().equalsIgnoreCase(dbType);
    }

    public abstract boolean getDefaultIfEmpty();

    public abstract String getDatabase();
}

