/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.security.entity.AuthenticationMethod;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OperateProfileService {
    public static final String CONSOLIDATED_AUTH = "consolidated-auth";
    @Autowired
    private Environment environment;

    public String getMessageByProfileFor(Exception exception) {
        if (exception != null && this.isDevelopmentProfileActive()) {
            return exception.getMessage();
        }
        return "";
    }

    public boolean isDevelopmentProfileActive() {
        return List.of(this.environment.getActiveProfiles()).contains("dev");
    }

    public boolean isConsolidatedAuthOidc() {
        Optional consolidatedAuthVariation = AuthenticationMethod.parse((String)this.environment.getProperty("camunda.security.authentication.method"));
        return consolidatedAuthVariation.isPresent() && AuthenticationMethod.OIDC.equals(consolidatedAuthVariation.get());
    }

    public boolean isLoginDelegated() {
        return this.isConsolidatedAuthOidc();
    }
}

