/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import io.camunda.operate.util.Convertable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MapPath {
    private final Map<String, Object> map;

    public MapPath(Map<String, Object> map) {
        this.map = map;
    }

    public static MapPath from(Map<String, Object> map) {
        return new MapPath(map);
    }

    public Optional<Convertable> getByPath(String ... path) {
        return this.getByPath(Arrays.asList(path));
    }

    public Optional<Convertable> getByPath(List<String> path) {
        Supplier<String> pathHead = () -> (String)path.get(0);
        Supplier<List> pathTail = () -> path.subList(1, path.size());
        Supplier<Object> headItem = () -> this.map.get(pathHead.get());
        return switch (path.size()) {
            case 0 -> Optional.empty();
            case 1 -> Optional.ofNullable(headItem.get()).map(Convertable::from);
            default -> Convertable.from(headItem.get()).to().flatMap(map -> MapPath.from(map).getByPath((List)pathTail.get()));
        };
    }
}

