/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.property;

import io.camunda.operate.property.SslProperties;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.search.connect.plugin.PluginConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class OpensearchProperties {
    public static final String OS_DATE_FORMAT_DEFAULT = "date_time";
    public static final int BULK_REQUEST_MAX_SIZE_IN_BYTES_DEFAULT = 0x5A00000;
    private String clusterName = "opensearch";
    @Deprecated
    private String host = "localhost";
    @Deprecated
    private int port = 9200;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private String osDateFormat = "date_time";
    private int batchSize = 200;
    private Integer socketTimeout;
    private Integer connectTimeout;
    private boolean createSchema = true;
    private boolean healthCheckEnabled = true;
    private String url;
    private String username;
    private String password;
    private int bulkRequestMaxSizeInBytes = 0x5A00000;
    private boolean awsEnabled = false;
    @NestedConfigurationProperty
    private SslProperties ssl;
    private List<PluginConfiguration> interceptorPlugins;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Deprecated
    public String getHost() {
        return this.getFromURIorDefault(URI::getHost, this.host);
    }

    @Deprecated
    public void setHost(String host) {
        this.host = host;
    }

    @Deprecated
    public int getPort() {
        return this.getFromURIorDefault(URI::getPort, this.port);
    }

    @Deprecated
    public void setPort(int port) {
        this.port = port;
    }

    private <T> T getFromURIorDefault(Function<URI, T> valueFromURI, T defaultValue) {
        if (!ConversionUtils.stringIsEmpty(this.url)) {
            try {
                return valueFromURI.apply(new URI(this.url));
            }
            catch (URISyntaxException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getOsDateFormat() {
        return this.osDateFormat;
    }

    public void setOsDateFormat(String osDateFormat) {
        this.osDateFormat = osDateFormat;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public void setHealthCheckEnabled(boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUrl() {
        if (ConversionUtils.stringIsEmpty(this.url)) {
            return String.format("http://%s:%d", this.getHost(), this.getPort());
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isAwsEnabled() {
        return this.awsEnabled;
    }

    public OpensearchProperties setAwsEnabled(boolean awsEnabled) {
        this.awsEnabled = awsEnabled;
        return this;
    }

    public SslProperties getSsl() {
        return this.ssl;
    }

    public void setSsl(SslProperties ssl) {
        this.ssl = ssl;
    }

    public long getBulkRequestMaxSizeInBytes() {
        return this.bulkRequestMaxSizeInBytes;
    }

    public void setBulkRequestMaxSizeInBytes(int bulkRequestMaxSizeInBytes) {
        this.bulkRequestMaxSizeInBytes = bulkRequestMaxSizeInBytes;
    }

    public List<PluginConfiguration> getInterceptorPlugins() {
        return this.interceptorPlugins;
    }

    public void setInterceptorPlugins(List<PluginConfiguration> interceptorPlugins) {
        this.interceptorPlugins = interceptorPlugins;
    }
}

