/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.security.entity.AuthenticationMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OperateProfileService {
    public static final String SSO_AUTH_PROFILE = "sso-auth";
    public static final String IDENTITY_AUTH_PROFILE = "identity-auth";
    public static final String AUTH_PROFILE = "auth";
    public static final String CONSOLIDATED_AUTH = "consolidated-auth";
    public static final String LDAP_AUTH_PROFILE = "ldap-auth";
    private static final Set<String> CANT_LOGOUT_AUTH_PROFILES = Set.of("sso-auth");
    @Autowired
    private Environment environment;

    public String getMessageByProfileFor(Exception exception) {
        if (exception != null && this.isDevelopmentProfileActive()) {
            return exception.getMessage();
        }
        return "";
    }

    public boolean isDevelopmentProfileActive() {
        return List.of(this.environment.getActiveProfiles()).contains("dev");
    }

    public boolean isDevelopmentDataProfileActive() {
        return List.of(this.environment.getActiveProfiles()).contains("dev-data");
    }

    public boolean isSSOProfile() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains(SSO_AUTH_PROFILE);
    }

    public boolean isConsolidatedAuthOidc() {
        Optional consolidatedAuthVariation = AuthenticationMethod.parse((String)this.environment.getProperty("camunda.security.authentication.method"));
        return consolidatedAuthVariation.isPresent() && AuthenticationMethod.OIDC.equals(consolidatedAuthVariation.get());
    }

    public boolean isIdentityProfile() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains(IDENTITY_AUTH_PROFILE);
    }

    public boolean currentProfileCanLogout() {
        return Arrays.stream(this.environment.getActiveProfiles()).noneMatch(CANT_LOGOUT_AUTH_PROFILES::contains);
    }

    public boolean isLoginDelegated() {
        return this.isIdentityProfile() || this.isSSOProfile() || this.isConsolidatedAuthOidc();
    }
}

