/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebe;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.property.ZeebeProperties;
import io.camunda.operate.util.ConditionalOnOperateCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnOperateCompatibility(enabled="true")
public class ZeebeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeConnector.class);
    private static final int JOB_WORKER_MAX_JOBS_ACTIVE = 5;
    @Autowired
    private OperateProperties operateProperties;

    @Bean
    public CamundaClient camundaClient() {
        ZeebeProperties properties = this.operateProperties.getZeebe();
        return this.newCamundaClient(properties);
    }

    public CamundaClient newCamundaClient(ZeebeProperties zeebeProperties) {
        String gatewayAddress = this.getGatewayAddress(zeebeProperties);
        CamundaClientBuilder builder = CamundaClient.newClientBuilder().gatewayAddress(gatewayAddress).defaultJobWorkerMaxJobsActive(5);
        if (zeebeProperties.isSecure()) {
            builder.caCertificatePath(zeebeProperties.getCertificatePath());
            LOGGER.info("Use TLS connection to zeebe");
        } else {
            builder.usePlaintext();
            LOGGER.info("Use plaintext connection to zeebe");
        }
        return builder.build();
    }

    private String getGatewayAddress(ZeebeProperties properties) {
        String deprecatedBrokerContactPoint = properties.getBrokerContactPoint();
        String gatewayAddress = properties.getGatewayAddress();
        String address = deprecatedBrokerContactPoint != null ? deprecatedBrokerContactPoint : gatewayAddress;
        return address;
    }
}

