/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util.rest;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.util.RetryOperation;
import io.camunda.operate.util.rest.StatefulHttpComponentsClientHttpRequestFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.elasticsearch.ElasticsearchException;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@Scope(value="prototype")
public class StatefulRestTemplate
extends RestTemplate {
    private static final String LOGIN_URL_PATTERN = "/api/login?username=%s&password=%s";
    private static final String CSRF_TOKEN_HEADER_NAME = "X-CSRF-TOKEN";
    private static final String USERNAME_DEFAULT = "demo";
    private static final String PASSWORD_DEFAULT = "demo";
    private final String host;
    private final Integer port;
    private final HttpClient httpClient;
    private final CookieStore cookieStore;
    private final HttpContext httpContext;
    private final StatefulHttpComponentsClientHttpRequestFactory statefulHttpComponentsClientHttpRequestFactory;
    private String csrfToken;
    private final String contextPath;

    public StatefulRestTemplate(String host, Integer port, String contextPath) {
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.httpClient = HttpClientBuilder.create().build();
        this.cookieStore = new BasicCookieStore();
        this.httpContext = new BasicHttpContext();
        this.httpContext.setAttribute("http.cookie-store", (Object)this.getCookieStore());
        this.statefulHttpComponentsClientHttpRequestFactory = new StatefulHttpComponentsClientHttpRequestFactory(this.httpClient, this.httpContext);
        super.setRequestFactory((ClientHttpRequestFactory)this.statefulHttpComponentsClientHttpRequestFactory);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) throws RestClientException {
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.method((HttpMethod)HttpMethod.POST, (URI)url).headers(this.getCsrfHeader())).contentType(MediaType.APPLICATION_JSON).body(request);
        ResponseEntity<T> tResponseEntity = this.exchange(requestEntity, responseType);
        this.saveCSRFTokenWhenAvailable(tResponseEntity);
        return tResponseEntity;
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        ResponseEntity responseEntity = super.exchange(requestEntity, responseType);
        this.saveCSRFTokenWhenAvailable(responseEntity);
        return responseEntity;
    }

    public <T> RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
        HttpEntity httpEntity;
        if (requestBody != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add(CSRF_TOKEN_HEADER_NAME, this.csrfToken);
            httpEntity = requestBody instanceof HttpEntity ? new HttpEntity(((HttpEntity)requestBody).getBody(), (MultiValueMap)headers) : new HttpEntity(requestBody, (MultiValueMap)headers);
        } else {
            httpEntity = null;
        }
        return super.httpEntityCallback(httpEntity, responseType);
    }

    public StatefulHttpComponentsClientHttpRequestFactory getStatefulHttpClientRequestFactory() {
        return this.statefulHttpComponentsClientHttpRequestFactory;
    }

    public void loginWhenNeeded() {
        this.loginWhenNeeded("demo", "demo");
    }

    public void loginWhenNeeded(String username, String password) {
        if (this.getCookieStore().getCookies().isEmpty()) {
            ResponseEntity<Object> response = this.tryLoginAs(username, password);
            if (!response.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                throw new OperateRuntimeException(String.format("Unable to login user %s to %s:%s. Response: %s", username, this.host, this.port, response));
            }
            this.saveCSRFTokenWhenAvailable(response);
        }
    }

    private ResponseEntity<Object> tryLoginAs(String username, String password) {
        try {
            return RetryOperation.newBuilder().retryConsumer(() -> this.postForEntity(this.getURL(String.format(LOGIN_URL_PATTERN, username, password)), null, Object.class)).noOfRetry(50).delayInterval(6, TimeUnit.SECONDS).retryOn(IOException.class, RestClientException.class, ElasticsearchException.class).message("StatefulRestTemplate#tryLoginAs").build().retry();
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Unable to connect to Operate ", e);
        }
    }

    private ResponseEntity<?> saveCSRFTokenWhenAvailable(ResponseEntity<?> response) {
        List csrfHeaders = response.getHeaders().get((Object)CSRF_TOKEN_HEADER_NAME);
        if (csrfHeaders != null && !csrfHeaders.isEmpty()) {
            this.csrfToken = (String)csrfHeaders.get(0);
        }
        return response;
    }

    public URI getURL(String urlPart) {
        try {
            String path;
            if (this.contextPath.endsWith("/") && urlPart.startsWith("/")) {
                String subUrlPart = urlPart.substring(1);
                path = this.contextPath + subUrlPart;
            } else {
                path = this.contextPath + urlPart;
            }
            return new URL(String.format("http://%s:%s%s", this.host, this.port, path)).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Error occurred while constructing URL", e);
        }
    }

    public URI getURL(String urlPart, String urlParams) {
        if (StringUtils.isEmpty((Object)urlParams)) {
            return this.getURL(urlPart);
        }
        try {
            return new URL(String.format("%s?%s", this.getURL(urlPart), urlParams)).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Error occurred while constructing URL", e);
        }
    }

    public Consumer<HttpHeaders> getCsrfHeader() {
        return header -> header.add(CSRF_TOKEN_HEADER_NAME, this.csrfToken);
    }
}

