/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.property;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.conditions.DatabaseType;
import io.camunda.operate.property.AlertingProperties;
import io.camunda.operate.property.Auth0Properties;
import io.camunda.operate.property.BackupProperties;
import io.camunda.operate.property.CloudProperties;
import io.camunda.operate.property.ClusterNodeProperties;
import io.camunda.operate.property.IdentityProperties;
import io.camunda.operate.property.ImportProperties;
import io.camunda.operate.property.LdapProperties;
import io.camunda.operate.property.OAuthClientProperties;
import io.camunda.operate.property.OperateElasticsearchProperties;
import io.camunda.operate.property.OperateOpensearchProperties;
import io.camunda.operate.property.OperationExecutorProperties;
import io.camunda.operate.property.WebSecurityProperties;
import io.camunda.operate.property.ZeebeElasticsearchProperties;
import io.camunda.operate.property.ZeebeOpensearchProperties;
import io.camunda.operate.property.ZeebeProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(value="camunda.operate")
@PropertySource(value={"classpath:operate-version.properties"})
@DependsOn(value={"databaseInfo"})
public class OperateProperties {
    public static final String PREFIX = "camunda.operate";
    public static final long BATCH_OPERATION_MAX_SIZE_DEFAULT = 1000000L;
    private static final String UNKNOWN_VERSION = "unknown-version";
    private boolean importerEnabled = true;
    private boolean webappEnabled = true;
    private boolean rfc3339ApiDateFormat = false;
    private boolean persistentSessionsEnabled = false;
    private boolean csrfPreventionEnabled = true;
    private String userId = "demo";
    private String displayName = "demo";
    private String password = "demo";
    private List<String> roles = List.of("OWNER");
    private Long batchOperationMaxSize = 1000000L;
    private boolean enterprise = false;
    private String tasklistUrl = null;
    @Value(value="${camunda.operate.internal.version.current}")
    private String version = "unknown-version";
    @NestedConfigurationProperty
    private OperateElasticsearchProperties elasticsearch = new OperateElasticsearchProperties();
    @NestedConfigurationProperty
    private OperateOpensearchProperties opensearch = new OperateOpensearchProperties();
    @NestedConfigurationProperty
    private ZeebeElasticsearchProperties zeebeElasticsearch = new ZeebeElasticsearchProperties();
    @NestedConfigurationProperty
    private ZeebeOpensearchProperties zeebeOpensearch = new ZeebeOpensearchProperties();
    @NestedConfigurationProperty
    private ZeebeProperties zeebe = new ZeebeProperties();
    @NestedConfigurationProperty
    private OperationExecutorProperties operationExecutor = new OperationExecutorProperties();
    @NestedConfigurationProperty
    private ImportProperties importer = new ImportProperties();
    @NestedConfigurationProperty
    private ClusterNodeProperties clusterNode = new ClusterNodeProperties();
    @NestedConfigurationProperty
    private LdapProperties ldap = new LdapProperties();
    @NestedConfigurationProperty
    private Auth0Properties auth0 = new Auth0Properties();
    @NestedConfigurationProperty
    private IdentityProperties identity = new IdentityProperties();
    @NestedConfigurationProperty
    private AlertingProperties alert = new AlertingProperties();
    @NestedConfigurationProperty
    private CloudProperties cloud = new CloudProperties();
    @NestedConfigurationProperty
    private OAuthClientProperties client = new OAuthClientProperties();
    @NestedConfigurationProperty
    private BackupProperties backup = new BackupProperties();
    @NestedConfigurationProperty
    private WebSecurityProperties webSecurity = new WebSecurityProperties();

    public boolean isImporterEnabled() {
        return this.importerEnabled;
    }

    public void setImporterEnabled(boolean importerEnabled) {
        this.importerEnabled = importerEnabled;
    }

    public boolean isWebappEnabled() {
        return this.webappEnabled;
    }

    public void setWebappEnabled(boolean webappEnabled) {
        this.webappEnabled = webappEnabled;
    }

    public Long getBatchOperationMaxSize() {
        return this.batchOperationMaxSize;
    }

    public void setBatchOperationMaxSize(Long batchOperationMaxSize) {
        this.batchOperationMaxSize = batchOperationMaxSize;
    }

    public boolean isCsrfPreventionEnabled() {
        return this.csrfPreventionEnabled;
    }

    public void setCsrfPreventionEnabled(boolean csrfPreventionEnabled) {
        this.csrfPreventionEnabled = csrfPreventionEnabled;
    }

    public OperateElasticsearchProperties getElasticsearch() {
        return this.elasticsearch;
    }

    public void setElasticsearch(OperateElasticsearchProperties elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    public OperateOpensearchProperties getOpensearch() {
        return this.opensearch;
    }

    public void setOpensearch(OperateOpensearchProperties opensearch) {
        this.opensearch = opensearch;
    }

    public ZeebeElasticsearchProperties getZeebeElasticsearch() {
        return this.zeebeElasticsearch;
    }

    public void setZeebeElasticsearch(ZeebeElasticsearchProperties zeebeElasticsearch) {
        this.zeebeElasticsearch = zeebeElasticsearch;
    }

    public ZeebeOpensearchProperties getZeebeOpensearch() {
        return this.zeebeOpensearch;
    }

    public void setZeebeOpensearch(ZeebeOpensearchProperties zeebeOpensearch) {
        this.zeebeOpensearch = zeebeOpensearch;
    }

    public ZeebeProperties getZeebe() {
        return this.zeebe;
    }

    public void setZeebe(ZeebeProperties zeebe) {
        this.zeebe = zeebe;
    }

    public LdapProperties getLdap() {
        return this.ldap;
    }

    public void setLdap(LdapProperties ldap) {
        this.ldap = ldap;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public OperationExecutorProperties getOperationExecutor() {
        return this.operationExecutor;
    }

    public void setOperationExecutor(OperationExecutorProperties operationExecutor) {
        this.operationExecutor = operationExecutor;
    }

    public ImportProperties getImporter() {
        return this.importer;
    }

    public void setImporter(ImportProperties importer) {
        this.importer = importer;
    }

    public ClusterNodeProperties getClusterNode() {
        return this.clusterNode;
    }

    public void setClusterNode(ClusterNodeProperties clusterNode) {
        this.clusterNode = clusterNode;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(boolean enterprise) {
        this.enterprise = enterprise;
    }

    public Auth0Properties getAuth0() {
        return this.auth0;
    }

    public OperateProperties setAuth0(Auth0Properties auth0) {
        this.auth0 = auth0;
        return this;
    }

    public WebSecurityProperties getWebSecurity() {
        return this.webSecurity;
    }

    public OperateProperties setWebSecurity(WebSecurityProperties webSecurity) {
        this.webSecurity = webSecurity;
        return this;
    }

    public IdentityProperties getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityProperties identity) {
        this.identity = identity;
    }

    public AlertingProperties getAlert() {
        return this.alert;
    }

    public OperateProperties setAlert(AlertingProperties alert) {
        this.alert = alert;
        return this;
    }

    public CloudProperties getCloud() {
        return this.cloud;
    }

    public OperateProperties setCloud(CloudProperties cloud) {
        this.cloud = cloud;
        return this;
    }

    public boolean isPersistentSessionsEnabled() {
        return this.persistentSessionsEnabled;
    }

    public OperateProperties setPersistentSessionsEnabled(boolean persistentSessionsEnabled) {
        this.persistentSessionsEnabled = persistentSessionsEnabled;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Deprecated(forRemoval=true)
    public OAuthClientProperties getClient() {
        return this.client;
    }

    @Deprecated(forRemoval=true)
    public void setClient(OAuthClientProperties client) {
        this.client = client;
    }

    public BackupProperties getBackup() {
        return this.backup;
    }

    public OperateProperties setBackup(BackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public String getTasklistUrl() {
        return this.tasklistUrl;
    }

    public void setTasklistUrl(String tasklistUrl) {
        this.tasklistUrl = tasklistUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public OperateProperties setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isRfc3339ApiDateFormat() {
        return this.rfc3339ApiDateFormat;
    }

    public void setRfc3339ApiDateFormat(boolean rfc3339ApiDateFormat) {
        this.rfc3339ApiDateFormat = rfc3339ApiDateFormat;
    }

    public String getIndexPrefix(DatabaseType databaseType) {
        return switch (databaseType) {
            case DatabaseType.Elasticsearch -> {
                if (this.getElasticsearch() == null) {
                    yield null;
                }
                yield this.getElasticsearch().getIndexPrefix();
            }
            case DatabaseType.Opensearch -> {
                if (this.getOpensearch() == null) {
                    yield null;
                }
                yield this.getOpensearch().getIndexPrefix();
            }
            default -> null;
        };
    }

    public String getIndexPrefix() {
        return this.getIndexPrefix(DatabaseInfo.getCurrent());
    }
}

