/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import io.camunda.operate.util.ThreadUtil;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.EvaluateDecisionResponse;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZeebeTestUtil {
    public static final Logger ALL_EVENTS_LOGGER = LoggerFactory.getLogger((String)"io.camunda.operate.ALL_EVENTS");
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeTestUtil.class);

    public static Long deployProcess(ZeebeClient client, String tenantId, String ... classpathResources) {
        return ZeebeTestUtil.deployProcess(false, client, tenantId, classpathResources);
    }

    public static Long deployProcess(boolean ignoreException, ZeebeClient client, String tenantId, String ... classpathResources) {
        try {
            if (classpathResources.length == 0) {
                return null;
            }
            DeployResourceCommandStep1 deployProcessCommandStep1 = client.newDeployResourceCommand();
            for (String classpathResource : classpathResources) {
                deployProcessCommandStep1 = deployProcessCommandStep1.addResourceFromClasspath(classpathResource);
            }
            if (tenantId != null) {
                deployProcessCommandStep1 = (DeployResourceCommandStep1)((DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1).tenantId(tenantId);
            }
            DeploymentEvent deploymentEvent = (DeploymentEvent)((DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1).send().join();
            LOGGER.debug("Deployment of resource [{}] was performed", (Object[])classpathResources);
            return ((Process)deploymentEvent.getProcesses().get(classpathResources.length - 1)).getProcessDefinitionKey();
        }
        catch (Exception e) {
            if (ignoreException) {
                LOGGER.warn("Deployment failed: " + e.getMessage());
                return null;
            }
            throw e;
        }
    }

    public static void deployDecision(ZeebeClient client, String tenantId, String ... classpathResources) {
        if (classpathResources.length == 0) {
            return;
        }
        DeployResourceCommandStep1 deployProcessCommandStep1 = client.newDeployResourceCommand();
        for (String classpathResource : classpathResources) {
            deployProcessCommandStep1 = deployProcessCommandStep1.addResourceFromClasspath(classpathResource);
        }
        if (tenantId != null) {
            deployProcessCommandStep1 = (DeployResourceCommandStep1)((DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1).tenantId(tenantId);
        }
        ((DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1).send().join();
        LOGGER.debug("Deployment of resource [{}] was performed", (Object[])classpathResources);
    }

    public static Long deployProcess(ZeebeClient client, String tenantId, BpmnModelInstance processModel, String resourceName) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployProcessCommandStep1 = client.newDeployResourceCommand().addProcessModel(processModel, resourceName);
        if (tenantId != null) {
            deployProcessCommandStep1 = (DeployResourceCommandStep1.DeployResourceCommandStep2)deployProcessCommandStep1.tenantId(tenantId);
        }
        DeploymentEvent deploymentEvent = (DeploymentEvent)deployProcessCommandStep1.send().join();
        LOGGER.debug("Deployment of resource [{}] was performed", (Object)resourceName);
        return ((Process)deploymentEvent.getProcesses().get(0)).getProcessDefinitionKey();
    }

    public static long startProcessInstance(ZeebeClient client, String bpmnProcessId, String payload) {
        return ZeebeTestUtil.startProcessInstance(client, null, bpmnProcessId, payload);
    }

    public static long startProcessInstance(ZeebeClient client, String tenantId, String bpmnProcessId, String payload) {
        return ZeebeTestUtil.startProcessInstance(false, client, tenantId, bpmnProcessId, payload);
    }

    public static long startProcessInstance(boolean ignoreException, ZeebeClient client, String tenantId, String bpmnProcessId, String payload) {
        return ZeebeTestUtil.startProcessInstance(false, client, tenantId, bpmnProcessId, null, payload);
    }

    public static long startProcessInstance(boolean ignoreException, ZeebeClient client, String tenantId, String bpmnProcessId, Integer processVersion, String payload) {
        try {
            CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3;
            CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep32 = createProcessInstanceCommandStep3 = processVersion == null ? client.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion() : client.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).version(processVersion.intValue());
            if (tenantId != null) {
                createProcessInstanceCommandStep3.tenantId(tenantId);
            }
            if (payload != null) {
                createProcessInstanceCommandStep3.variables(payload);
            }
            ProcessInstanceEvent processInstanceEvent = null;
            try {
                processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
                LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
            }
            catch (ClientException ex) {
                ThreadUtil.sleepFor(300L);
                processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
                LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
            }
            return processInstanceEvent.getProcessInstanceKey();
        }
        catch (Exception e) {
            if (ignoreException) {
                LOGGER.warn("Instance creation failed: " + e.getMessage());
                return 0L;
            }
            throw e;
        }
    }

    public static void cancelProcessInstance(boolean ignoreException, ZeebeClient client, long processInstanceKey) {
        try {
            client.newCancelInstanceCommand(processInstanceKey).send().join();
        }
        catch (Exception e) {
            if (!ignoreException) {
                throw e;
            }
            LOGGER.warn("Cancellation failed: " + e.getMessage());
        }
    }

    public static void cancelProcessInstance(ZeebeClient client, long processInstanceKey) {
        ZeebeTestUtil.cancelProcessInstance(false, client, processInstanceKey);
    }

    public static long evaluateDecisionInstance(ZeebeClient client, String decisionId, Map<String, Object> variables) {
        EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 evaluateDecisionCommandStep2 = client.newEvaluateDecisionCommand().decisionId(decisionId).variables(variables);
        EvaluateDecisionResponse evaluateDecision = null;
        try {
            evaluateDecision = (EvaluateDecisionResponse)evaluateDecisionCommandStep2.send().join();
            LOGGER.debug("Evaluate decision created for decision [{}]", (Object)decisionId);
        }
        catch (ClientException ex) {
            ThreadUtil.sleepFor(300L);
            evaluateDecision = (EvaluateDecisionResponse)evaluateDecisionCommandStep2.send().join();
            LOGGER.debug("Evaluate decision created for decision [{}]", (Object)decisionId);
        }
        return evaluateDecision.getDecisionInstanceKey();
    }

    public static void completeTask(ZeebeClient client, String jobType, String workerName, String payload) {
        ZeebeTestUtil.completeTask(client, jobType, workerName, payload, 1);
    }

    public static void completeTask(ZeebeClient client, String jobType, String workerName, String payload, int count) {
        ZeebeTestUtil.handleTasks(client, jobType, workerName, count, (jobClient, job) -> {
            CompleteJobCommandStep1 command = jobClient.newCompleteCommand(job.getKey());
            if (payload != null) {
                command.variables(payload);
            }
            command.send().join();
        });
    }

    public static Long failTask(ZeebeClient client, String jobType, String workerName, int numberOfFailures, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, numberOfFailures, (jobClient, job) -> {
            FailJobCommandStep1.FailJobCommandStep2 failCommand = jobClient.newFailCommand(job.getKey()).retries(job.getRetries() - 1);
            if (errorMessage != null) {
                failCommand.errorMessage(errorMessage);
            }
            failCommand.send().join();
        }).get(0);
    }

    public static Long failTaskWithRetriesLeft(ZeebeClient client, String jobType, String workerName, int numberOfRetriesLeft, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, 1, (jobClient, job) -> {
            FailJobCommandStep1.FailJobCommandStep2 failCommand = jobClient.newFailCommand(job.getKey()).retries(numberOfRetriesLeft);
            if (errorMessage != null) {
                failCommand.errorMessage(errorMessage);
            }
            failCommand.send().join();
        }).get(0);
    }

    public static Long throwErrorInTask(ZeebeClient client, String jobType, String workerName, int numberOfFailures, String errorCode, String errorMessage) {
        return ZeebeTestUtil.handleTasks(client, jobType, workerName, numberOfFailures, (jobClient, job) -> jobClient.newThrowErrorCommand(job.getKey()).errorCode(errorCode).errorMessage(errorMessage).send().join()).get(0);
    }

    private static List<Long> handleTasks(ZeebeClient client, String jobType, String workerName, int jobCount, BiConsumer<JobClient, ActivatedJob> jobHandler) {
        ArrayList<Long> jobKeys = new ArrayList<Long>();
        while (jobKeys.size() < jobCount) {
            ((ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(jobCount - jobKeys.size()).workerName(workerName).timeout(Duration.ofSeconds(2L)).send().join()).getJobs().forEach(job -> {
                jobHandler.accept((JobClient)client, (ActivatedJob)job);
                jobKeys.add(job.getKey());
            });
        }
        return jobKeys;
    }

    public static void resolveIncident(ZeebeClient client, Long jobKey, Long incidentKey) {
        client.newUpdateRetriesCommand(jobKey.longValue()).retries(3).send().join();
        client.newResolveIncidentCommand(incidentKey.longValue()).send().join();
    }

    public static void updateVariables(ZeebeClient client, Long scopeKey, String newPayload) {
        client.newSetVariablesCommand(scopeKey.longValue()).variables(newPayload).local(true).send().join();
    }

    public static void sendMessages(ZeebeClient client, String messageName, String payload, int count, String correlationKey) {
        for (int i = 0; i < count; ++i) {
            client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).variables(payload).timeToLive(Duration.ofSeconds(30L)).messageId(UUID.randomUUID().toString()).send().join();
        }
    }

    public static void sendSignal(ZeebeClient client, String signalName, String payload, int count) {
        for (int i = 0; i < count; ++i) {
            client.newBroadcastSignalCommand().signalName(signalName).variables(payload).send().join();
        }
    }
}

