/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebe;

import io.camunda.operate.ApplicationShutdownService;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ThreadUtil;
import io.camunda.webapps.zeebe.PartitionSupplier;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PartitionHolder {
    public static final long WAIT_TIME_IN_MS = 1000L;
    public static final int MAX_RETRY = 60;
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionHolder.class);
    private List<Integer> partitionIds = new ArrayList<Integer>();
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    @Qualifier(value="operatePartitionSupplier")
    private PartitionSupplier partitionSupplier;
    @Autowired(required=false)
    private ApplicationShutdownService applicationShutdownService;

    public List<Integer> getPartitionIds() {
        List<Integer> ids = this.getPartitionIdsWithWaitingTimeAndRetries(1000L, 60);
        if (ids.isEmpty() && this.applicationShutdownService != null) {
            LOGGER.error("Operate needs an established connection to Zeebe in order to retrieve Zeebe Partitions. Shutting down...");
            this.applicationShutdownService.shutdown();
        }
        return ids;
    }

    private List<Integer> getPartitionIdsWithWaitingTimeAndRetries(long waitingTimeInMilliseconds, int maxRetries) {
        for (int retries = 0; this.partitionIds.isEmpty() && retries <= maxRetries; ++retries) {
            Optional<List<Integer>> zeebePartitionIds;
            if (retries > 0) {
                this.sleepFor(waitingTimeInMilliseconds);
            }
            if ((zeebePartitionIds = this.getPartitionIdsFromZeebe()).isPresent()) {
                this.partitionIds = this.extractCurrentNodePartitions(zeebePartitionIds.get());
                continue;
            }
            if (retries <= maxRetries) {
                LOGGER.info("Partition ids can't be fetched from Zeebe. Try next round ({}).", (Object)retries);
                continue;
            }
            LOGGER.info("Partition ids can't be fetched from Zeebe. Return empty partition ids list.");
        }
        return this.partitionIds;
    }

    protected List<Integer> extractCurrentNodePartitions(List<Integer> partitionIds) {
        Integer[] configuredIds = this.operateProperties.getClusterNode().getPartitionIds();
        if (configuredIds != null && configuredIds.length > 0) {
            partitionIds.retainAll(Arrays.asList(configuredIds));
        } else if (this.operateProperties.getClusterNode().getNodeCount() != null && this.operateProperties.getClusterNode().getCurrentNodeId() != null) {
            Integer nodeCount = this.operateProperties.getClusterNode().getNodeCount();
            Integer nodeId = this.operateProperties.getClusterNode().getCurrentNodeId();
            if (nodeId >= nodeCount) {
                LOGGER.warn("Misconfiguration: nodeId [{}] must be strictly less than nodeCount [{}]. No partitions will be selected.", (Object)nodeId, (Object)nodeCount);
            }
            partitionIds = CollectionUtil.splitAndGetSublist(partitionIds, nodeCount, nodeId);
        }
        return partitionIds;
    }

    protected Optional<List<Integer>> getPartitionIdsFromZeebe() {
        LOGGER.debug("Requesting partition ids");
        Either result = this.partitionSupplier.getPartitionsCount();
        if (result.isLeft()) {
            Exception t = (Exception)result.getLeft();
            LOGGER.warn("Error occurred when requesting partition ids from Zeebe client: " + t.getMessage(), (Throwable)t);
        } else {
            Integer partitionCount = (Integer)result.get();
            if (partitionCount > 0) {
                return Optional.of(CollectionUtil.fromTo(1, partitionCount));
            }
        }
        return Optional.empty();
    }

    protected void sleepFor(long milliseconds) {
        ThreadUtil.sleepFor(milliseconds);
    }

    public void setPartitionSupplier(PartitionSupplier partitionSupplier) {
        this.partitionSupplier = partitionSupplier;
    }
}

