/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.connect;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.opensearch.ExtendedOpenSearchClient;
import io.camunda.operate.property.OpensearchProperties;
import io.camunda.operate.property.OperateOpensearchProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.property.SslProperties;
import io.camunda.search.connect.plugin.PluginRepository;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.ElasticsearchException;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.cluster.HealthRequest;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

@Configuration
@Conditional(value={OpensearchCondition.class})
public class OpensearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchConnector.class);
    private PluginRepository osClientRepository = new PluginRepository();
    private PluginRepository zeebeOsClientRepository = new PluginRepository();
    private final OperateProperties operateProperties;
    private final ObjectMapper objectMapper;

    public OpensearchConnector(OperateProperties operateProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.operateProperties = operateProperties;
        this.objectMapper = objectMapper;
    }

    public void setOsClientRepository(PluginRepository osClientRepository) {
        this.osClientRepository = osClientRepository;
    }

    public void setZeebeOsClientRepository(PluginRepository zeebeOsClientRepository) {
        this.zeebeOsClientRepository = zeebeOsClientRepository;
    }

    @Bean
    @Primary
    public OpenSearchClient openSearchClient() {
        this.osClientRepository.load(this.operateProperties.getOpensearch().getInterceptorPlugins());
        OpenSearchClient openSearchClient = this.createOsClient(this.operateProperties.getOpensearch(), this.osClientRepository);
        if (this.operateProperties.getOpensearch().isHealthCheckEnabled()) {
            try {
                HealthResponse response = openSearchClient.cluster().health();
                LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
            }
            catch (IOException e) {
                LOGGER.error("Error in getting health status from {}", (Object)"localhost:9205", (Object)e);
            }
        } else {
            LOGGER.warn("OpenSearch cluster health check is disabled.");
        }
        return openSearchClient;
    }

    @Bean
    public OpenSearchAsyncClient openSearchAsyncClient() {
        this.osClientRepository.load(this.operateProperties.getOpensearch().getInterceptorPlugins());
        OpenSearchAsyncClient openSearchClient = this.createAsyncOsClient(this.operateProperties.getOpensearch(), this.osClientRepository);
        if (this.operateProperties.getOpensearch().isHealthCheckEnabled()) {
            try {
                CompletableFuture healthResponse = openSearchClient.cluster().health();
                healthResponse.whenComplete((response, e) -> {
                    if (e != null) {
                        LOGGER.error("Error in getting health status from {}", (Object)"localhost:9205", e);
                    } else {
                        LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
                    }
                });
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            LOGGER.warn("OpenSearch cluster health check is disabled.");
        }
        return openSearchClient;
    }

    @Bean(value={"zeebeOpensearchClient"})
    public OpenSearchClient zeebeOpensearchClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.zeebeOsClientRepository.load(this.operateProperties.getZeebeOpensearch().getInterceptorPlugins());
        return this.createOsClient(this.operateProperties.getZeebeOpensearch(), this.zeebeOsClientRepository);
    }

    public OpenSearchAsyncClient createAsyncOsClient(OpensearchProperties osConfig, PluginRepository osClientRepository) {
        LOGGER.debug("Creating Async OpenSearch connection...");
        LOGGER.debug("Creating OpenSearch connection...");
        if (this.hasAwsCredentials()) {
            return this.getAwsAsyncClient(osConfig);
        }
        HttpHost host = this.getHttpHost(osConfig);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureHttpClient(httpClientBuilder, osConfig, new HttpRequestInterceptor[]{osClientRepository.asRequestInterceptor()});
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            this.setTimeouts(requestConfigBuilder, osConfig);
            return requestConfigBuilder;
        });
        JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper();
        jsonpMapper.objectMapper().registerModule((Module)new JavaTimeModule());
        builder.setMapper((JsonpMapper)jsonpMapper);
        ApacheHttpClient5Transport transport = builder.build();
        OpenSearchAsyncClient openSearchAsyncClient = new OpenSearchAsyncClient((OpenSearchTransport)transport);
        if (this.operateProperties.getOpensearch().isHealthCheckEnabled()) {
            try {
                CompletableFuture healthResponse = openSearchAsyncClient.cluster().health();
                healthResponse.whenComplete((response, e) -> {
                    if (e != null) {
                        LOGGER.error("Error in getting health status from {}", (Object)"localhost:9205", e);
                    } else {
                        LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
                    }
                });
            }
            catch (IOException e2) {
                throw new OperateRuntimeException(e2);
            }
            if (!this.checkHealth(openSearchAsyncClient)) {
                LOGGER.warn("OpenSearch cluster is not accessible");
            } else {
                LOGGER.debug("OpenSearch connection was successfully created.");
            }
        } else {
            LOGGER.warn("OpenSearch cluster health check is disabled.");
        }
        return openSearchAsyncClient;
    }

    private boolean hasAwsCredentials() {
        if (!this.operateProperties.getOpensearch().isAwsEnabled()) {
            LOGGER.info("AWS Credentials are disabled. Using basic auth.");
            return false;
        }
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        try {
            credentialsProvider.resolveCredentials();
            LOGGER.info("AWS Credentials can be resolved. Use AWS Opensearch");
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("AWS not configured due to: {} ", (Object)e.getMessage());
            return false;
        }
    }

    public OpenSearchClient createOsClient(OpensearchProperties osConfig, PluginRepository osClientRepository) {
        LOGGER.debug("Creating OpenSearch connection...");
        if (this.hasAwsCredentials()) {
            return this.getAwsClient(osConfig);
        }
        HttpHost host = this.getHttpHost(osConfig);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureHttpClient(httpClientBuilder, osConfig, new HttpRequestInterceptor[]{osClientRepository.asRequestInterceptor()});
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            this.setTimeouts(requestConfigBuilder, osConfig);
            return requestConfigBuilder;
        });
        JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper(this.objectMapper);
        builder.setMapper((JsonpMapper)jsonpMapper);
        ApacheHttpClient5Transport transport = builder.build();
        ExtendedOpenSearchClient openSearchClient = new ExtendedOpenSearchClient((OpenSearchTransport)transport);
        if (this.operateProperties.getOpensearch().isHealthCheckEnabled()) {
            try {
                HealthResponse response = openSearchClient.cluster().health();
                LOGGER.info("OpenSearch cluster health: {}", (Object)response.status());
            }
            catch (IOException e) {
                LOGGER.error("Error in getting health status from {}", (Object)"localhost:9205", (Object)e);
            }
            if (!this.checkHealth(openSearchClient)) {
                LOGGER.warn("OpenSearch cluster is not accessible");
            } else {
                LOGGER.debug("OpenSearch connection was successfully created.");
            }
        } else {
            LOGGER.warn("OpenSearch cluster health check is disabled.");
        }
        return openSearchClient;
    }

    private OpenSearchClient getAwsClient(OpensearchProperties osConfig) {
        Region region = new DefaultAwsRegionProviderChain().getRegion();
        SdkHttpClient httpClient = AwsCrtHttpClient.builder().build();
        AwsSdk2Transport transport = new AwsSdk2Transport(httpClient, osConfig.getHost(), region, AwsSdk2TransportOptions.builder().setMapper((JsonpMapper)new JacksonJsonpMapper(this.objectMapper)).build());
        return new ExtendedOpenSearchClient((OpenSearchTransport)transport);
    }

    private OpenSearchAsyncClient getAwsAsyncClient(OpensearchProperties osConfig) {
        Region region = new DefaultAwsRegionProviderChain().getRegion();
        SdkHttpClient httpClient = AwsCrtHttpClient.builder().build();
        AwsSdk2Transport transport = new AwsSdk2Transport(httpClient, osConfig.getHost(), region, AwsSdk2TransportOptions.builder().setMapper((JsonpMapper)new JacksonJsonpMapper(this.objectMapper)).build());
        return new OpenSearchAsyncClient((OpenSearchTransport)transport);
    }

    private HttpHost getHttpHost(OpensearchProperties osConfig) {
        try {
            URI uri = new URI(osConfig.getUrl());
            return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException e) {
            throw new OperateRuntimeException("Error in url: " + osConfig.getUrl(), e);
        }
    }

    private HttpAsyncClientBuilder setupAuthentication(HttpAsyncClientBuilder builder, OpensearchProperties osConfig) {
        if (!StringUtils.hasText((String)osConfig.getUsername()) || !StringUtils.hasText((String)osConfig.getPassword())) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for OpenSearch is not used.");
            return builder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.getHttpHost(osConfig)), (Credentials)new UsernamePasswordCredentials(osConfig.getUsername(), osConfig.getPassword().toCharArray()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return builder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SslProperties sslConfig) {
        try {
            ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create();
            tlsStrategyBuilder.setSslContext(this.getSSLContext(sslConfig));
            if (!sslConfig.isVerifyHostname()) {
                tlsStrategyBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            TlsStrategy tlsStrategy = tlsStrategyBuilder.build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
            httpAsyncClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private SSLContext getSSLContext(SslProperties sslConfig) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy;
        KeyStore truststore = this.loadCustomTrustStore(sslConfig);
        TrustSelfSignedStrategy trustSelfSignedStrategy = trustStrategy = sslConfig.isSelfSigned() ? new TrustSelfSignedStrategy() : null;
        if (truststore.size() > 0) {
            return SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)trustStrategy).build();
        }
        return SSLContext.getDefault();
    }

    private KeyStore loadCustomTrustStore(SslProperties sslConfig) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            String serverCertificate = sslConfig.getCertificatePath();
            if (serverCertificate != null) {
                this.setCertificateInTrustStore(trustStore, serverCertificate);
            }
            return trustStore;
        }
        catch (Exception e) {
            String message = "Could not create certificate trustStore for the secured OpenSearch Connection!";
            throw new OperateRuntimeException("Could not create certificate trustStore for the secured OpenSearch Connection!", e);
        }
    }

    private void setCertificateInTrustStore(KeyStore trustStore, String serverCertificate) {
        try {
            Certificate cert = this.loadCertificateFromPath(serverCertificate);
            trustStore.setCertificateEntry("opensearch-host", cert);
        }
        catch (Exception e) {
            String message = "Could not load configured server certificate for the secured OpenSearch Connection!";
            throw new OperateRuntimeException("Could not load configured server certificate for the secured OpenSearch Connection!", e);
        }
    }

    private Certificate loadCertificateFromPath(String certificatePath) throws IOException, CertificateException {
        Certificate cert;
        block6: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certificatePath));){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() > 0) {
                    cert = cf.generateCertificate(bis);
                    LOGGER.debug("Found certificate: {}", (Object)cert);
                    break block6;
                }
                throw new OperateRuntimeException("Could not load certificate from file, file is empty. File: " + certificatePath);
            }
        }
        return cert;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, OpensearchProperties osConfig, HttpRequestInterceptor ... requestInterceptors) {
        this.setupAuthentication(httpAsyncClientBuilder, osConfig);
        LOGGER.trace("Attempt to load interceptor plugins");
        for (HttpRequestInterceptor interceptor : requestInterceptors) {
            httpAsyncClientBuilder.addRequestInterceptorLast(interceptor);
        }
        if (osConfig.getSsl() != null) {
            this.setupSSLContext(httpAsyncClientBuilder, osConfig.getSsl());
        }
        return httpAsyncClientBuilder;
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, OpensearchProperties os) {
        if (os.getSocketTimeout() != null) {
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)os.getSocketTimeout().intValue()));
        }
        if (os.getConnectTimeout() != null) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)os.getConnectTimeout().intValue()));
        }
        return builder;
    }

    public boolean checkHealth(OpenSearchClient osClient) {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        RetryPolicy<Boolean> retryPolicy = this.getConnectionRetryPolicy(osConfig);
        return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            HealthResponse clusterHealthResponse = osClient.cluster().health(new HealthRequest.Builder().build());
            return clusterHealthResponse.clusterName().equals(osConfig.getClusterName());
        });
    }

    public boolean checkHealth(OpenSearchAsyncClient osAsyncClient) {
        OperateOpensearchProperties osConfig = this.operateProperties.getOpensearch();
        RetryPolicy<Boolean> retryPolicy = this.getConnectionRetryPolicy(osConfig);
        return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            CompletableFuture clusterHealthResponse = osAsyncClient.cluster().health(new HealthRequest.Builder().build());
            clusterHealthResponse.whenComplete((response, e) -> {
                if (e != null) {
                    LOGGER.error(String.format("Error checking async health %", e.getMessage()));
                } else {
                    LOGGER.debug("Succesfully returned checkHealth");
                }
            });
            return ((HealthResponse)clusterHealthResponse.get()).clusterName().equals(osConfig.getClusterName());
        });
    }

    private RetryPolicy<Boolean> getConnectionRetryPolicy(OpensearchProperties osConfig) {
        String logMessage = String.format("connect to OpenSearch at %s", osConfig.getUrl());
        return ((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, ElasticsearchException.class})).withDelay(Duration.ofSeconds(3L)).withMaxAttempts(50).onRetry(e -> LOGGER.info("Retrying #{} {} due to {}", new Object[]{e.getAttemptCount(), logMessage, e.getLastFailure()})).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)logMessage, (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)logMessage));
    }
}

