/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.connect;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.ElasticsearchProperties;
import io.camunda.operate.property.OperateElasticsearchProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.property.SslProperties;
import io.camunda.operate.util.RetryOperation;
import io.camunda.search.connect.plugin.PluginRepository;
import jakarta.annotation.PreDestroy;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RestHighLevelClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(value={ElasticsearchCondition.class})
@Configuration
public class ElasticsearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConnector.class);
    private PluginRepository esClientRepository = new PluginRepository();
    private PluginRepository zeebeEsClientRepository = new PluginRepository();
    private final OperateProperties operateProperties;
    private ElasticsearchClient elasticsearchClient;

    public ElasticsearchConnector(OperateProperties operateProperties) {
        this.operateProperties = operateProperties;
    }

    public void setEsClientRepository(PluginRepository esClientRepository) {
        this.esClientRepository = esClientRepository;
    }

    public void setZeebeEsClientRepository(PluginRepository zeebeEsClientRepository) {
        this.zeebeEsClientRepository = zeebeEsClientRepository;
    }

    public static void closeEsClient(RestHighLevelClient esClient) {
        if (esClient != null) {
            try {
                esClient.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close esClient", (Throwable)e);
            }
        }
    }

    public static void closeEsClient(ElasticsearchClient esClient) {
        if (esClient != null) {
            esClient.shutdown();
        }
    }

    @Bean
    public ElasticsearchClient elasticsearchClient() {
        LOGGER.debug("Creating ElasticsearchClient ...");
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        this.esClientRepository.load(this.operateProperties.getElasticsearch().getInterceptorPlugins());
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getHttpHost(elsConfig)});
        if (elsConfig.getConnectTimeout() != null || elsConfig.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, elsConfig));
        }
        RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, elsConfig, new HttpRequestInterceptor[]{this.esClientRepository.asRequestInterceptor()})).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        if (this.operateProperties.getElasticsearch().isHealthCheckEnabled()) {
            if (!this.checkHealth(this.elasticsearchClient)) {
                LOGGER.warn("Elasticsearch cluster is not accessible");
            } else {
                LOGGER.debug("Elasticsearch connection was successfully created.");
            }
        } else {
            LOGGER.warn("Elasticsearch cluster health check is disabled.");
        }
        return this.elasticsearchClient;
    }

    public boolean checkHealth(ElasticsearchClient elasticsearchClient) {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        try {
            return RetryOperation.newBuilder().noOfRetry(50).retryOn(IOException.class, ElasticsearchException.class).delayInterval(3, TimeUnit.SECONDS).message(String.format("Connect to Elasticsearch cluster [%s] at %s", elsConfig.getClusterName(), elsConfig.getUrl())).retryConsumer(() -> {
                HealthResponse healthResponse = elasticsearchClient.cluster().health();
                LOGGER.info("Elasticsearch cluster health: {}", (Object)healthResponse.status());
                return healthResponse.clusterName().equals(elsConfig.getClusterName());
            }).build().retry();
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Couldn't connect to Elasticsearch. Abort.", e);
        }
    }

    @Bean
    public RestHighLevelClient esClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.esClientRepository.load(this.operateProperties.getElasticsearch().getInterceptorPlugins());
        return this.createEsClient(this.operateProperties.getElasticsearch(), this.esClientRepository);
    }

    @Bean(value={"zeebeEsClient"})
    public RestHighLevelClient zeebeEsClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.zeebeEsClientRepository.load(this.operateProperties.getZeebeElasticsearch().getInterceptorPlugins());
        return this.createEsClient(this.operateProperties.getZeebeElasticsearch(), this.zeebeEsClientRepository);
    }

    @PreDestroy
    public void tearDown() {
        if (this.elasticsearchClient != null) {
            try {
                ((ElasticsearchTransport)this.elasticsearchClient._transport()).close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public RestHighLevelClient createEsClient(ElasticsearchProperties elsConfig, PluginRepository pluginRepository) {
        LOGGER.debug("Creating Elasticsearch connection...");
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getHttpHost(elsConfig)}).setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, elsConfig, new HttpRequestInterceptor[]{pluginRepository.asRequestInterceptor()}));
        if (elsConfig.getConnectTimeout() != null || elsConfig.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, elsConfig));
        }
        RestHighLevelClient esClient = new RestHighLevelClientBuilder(restClientBuilder.build()).setApiCompatibilityMode(Boolean.valueOf(true)).build();
        if (this.operateProperties.getElasticsearch().isHealthCheckEnabled()) {
            if (!this.checkHealth(esClient)) {
                LOGGER.warn("Elasticsearch cluster is not accessible");
            } else {
                LOGGER.debug("Elasticsearch connection was successfully created.");
            }
        } else {
            LOGGER.warn("Elasticsearch cluster health check is disabled.");
        }
        return esClient;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ElasticsearchProperties elsConfig, HttpRequestInterceptor ... interceptors) {
        this.setupAuthentication(httpAsyncClientBuilder, elsConfig);
        LOGGER.trace("Attempt to load interceptor plugins");
        for (HttpRequestInterceptor interceptor : interceptors) {
            httpAsyncClientBuilder.addInterceptorLast(interceptor);
        }
        if (elsConfig.getSsl() != null) {
            this.setupSSLContext(httpAsyncClientBuilder, elsConfig.getSsl());
        }
        return httpAsyncClientBuilder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SslProperties sslConfig) {
        try {
            httpAsyncClientBuilder.setSSLContext(this.getSSLContext(sslConfig));
            if (!sslConfig.isVerifyHostname()) {
                httpAsyncClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private SSLContext getSSLContext(SslProperties sslConfig) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy;
        KeyStore truststore = this.loadCustomTrustStore(sslConfig);
        TrustSelfSignedStrategy trustSelfSignedStrategy = trustStrategy = sslConfig.isSelfSigned() ? new TrustSelfSignedStrategy() : null;
        if (truststore.size() > 0) {
            return SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)trustStrategy).build();
        }
        return SSLContext.getDefault();
    }

    private KeyStore loadCustomTrustStore(SslProperties sslConfig) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            String serverCertificate = sslConfig.getCertificatePath();
            if (serverCertificate != null) {
                this.setCertificateInTrustStore(trustStore, serverCertificate);
            }
            return trustStore;
        }
        catch (Exception e) {
            String message = "Could not create certificate trustStore for the secured Elasticsearch Connection!";
            throw new OperateRuntimeException("Could not create certificate trustStore for the secured Elasticsearch Connection!", e);
        }
    }

    private void setCertificateInTrustStore(KeyStore trustStore, String serverCertificate) {
        try {
            Certificate cert = this.loadCertificateFromPath(serverCertificate);
            trustStore.setCertificateEntry("elasticsearch-host", cert);
        }
        catch (Exception e) {
            String message = "Could not load configured server certificate for the secured Elasticsearch Connection!";
            throw new OperateRuntimeException("Could not load configured server certificate for the secured Elasticsearch Connection!", e);
        }
    }

    private Certificate loadCertificateFromPath(String certificatePath) throws IOException, CertificateException {
        Certificate cert;
        block6: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certificatePath));){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() > 0) {
                    cert = cf.generateCertificate(bis);
                    LOGGER.debug("Found certificate: {}", (Object)cert);
                    break block6;
                }
                throw new OperateRuntimeException("Could not load certificate from file, file is empty. File: " + certificatePath);
            }
        }
        return cert;
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ElasticsearchProperties elsConfig) {
        if (elsConfig.getSocketTimeout() != null) {
            builder.setSocketTimeout(elsConfig.getSocketTimeout().intValue());
        }
        if (elsConfig.getConnectTimeout() != null) {
            builder.setConnectTimeout(elsConfig.getConnectTimeout().intValue());
        }
        return builder;
    }

    private HttpHost getHttpHost(ElasticsearchProperties elsConfig) {
        try {
            URI uri = new URI(elsConfig.getUrl());
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        catch (URISyntaxException e) {
            throw new OperateRuntimeException("Error in url: " + elsConfig.getUrl(), e);
        }
    }

    private void setupAuthentication(HttpAsyncClientBuilder builder, ElasticsearchProperties elsConfig) {
        String username = elsConfig.getUsername();
        String password = elsConfig.getPassword();
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for elasticsearch is not used.");
            return;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    public boolean checkHealth(RestHighLevelClient esClient) {
        OperateElasticsearchProperties elsConfig = this.operateProperties.getElasticsearch();
        try {
            return RetryOperation.newBuilder().noOfRetry(50).retryOn(IOException.class, org.elasticsearch.ElasticsearchException.class).delayInterval(3, TimeUnit.SECONDS).message(String.format("Connect to Elasticsearch cluster [%s] at %s", elsConfig.getClusterName(), elsConfig.getUrl())).retryConsumer(() -> {
                ClusterHealthResponse clusterHealthResponse = esClient.cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT);
                return clusterHealthResponse.getClusterName().equals(elsConfig.getClusterName());
            }).build().retry();
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Couldn't connect to Elasticsearch. Abort.", e);
        }
    }
}

