/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Queue;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Metrics {
    public static final String OPERATE_NAMESPACE = "operate.";
    public static final String TIMER_NAME_QUERY = "operate.query";
    public static final String TIMER_NAME_IMPORT_QUERY = "operate.import.query";
    public static final String TIMER_NAME_IMPORT_INDEX_QUERY = "operate.import.index.query";
    public static final String TIMER_NAME_IMPORT_PROCESS_BATCH = "operate.import.process.batch";
    public static final String TIMER_NAME_IMPORT_TIME = "operate.import.time";
    public static final String TIMER_NAME_IMPORT_JOB_SCHEDULED_TIME = "operate.import.job.scheduled";
    public static final String TIMER_NAME_IMPORT_PROCESSING_DURATION = "operate.import.processing.duration";
    public static final String TIMER_NAME_IMPORT_POSITION_UPDATE = "operate.import.position.update";
    public static final String TIMER_NAME_ARCHIVER_QUERY = "operate.archiver.query";
    public static final String TIMER_NAME_ARCHIVER_REINDEX_QUERY = "operate.archiver.reindex.query";
    public static final String TIMER_NAME_ARCHIVER_DELETE_QUERY = "operate.archiver.delete.query";
    public static final String TIMER_NAME_IMPORT_FNI_TREE_PATH_CACHE_ACCESS = "operate.import.fni.tree.path.cache.access";
    public static final String COUNTER_NAME_EVENTS_PROCESSED = "events.processed";
    public static final String COUNTER_NAME_EVENTS_PROCESSED_FINISHED_WI = "events.processed.finished.process.instances";
    public static final String COUNTER_NAME_COMMANDS = "commands";
    public static final String COUNTER_NAME_ARCHIVED = "archived.process.instances";
    public static final String COUNTER_NAME_IMPORT_FNI_TREE_PATH_CACHE_RESULT = "import.fni.tree.path.cache.result";
    public static final String COUNTER_NAME_REINDEX_FAILURES = "archival.reindex.failures";
    public static final String COUNTER_NAME_DELETE_FAILURES = "archival.delete.failures";
    public static final String GAUGE_IMPORT_QUEUE_SIZE = "operate.import.queue.size";
    public static final String GAUGE_POST_IMPORTER_QUEUE_SIZE = "operate.post.importer.queue.size";
    public static final String GAUGE_BPMN_MODEL_COUNT = "operate.model.bpmn.count";
    public static final String GAUGE_DMN_MODEL_COUNT = "operate.model.dmn.count";
    public static final String GAUGE_NAME_IMPORT_FNI_TREE_PATH_CACHE_SIZE = "operate.import.fni.tree.path.cache.size";
    public static final String TAG_KEY_NAME = "name";
    public static final String TAG_KEY_TYPE = "type";
    public static final String TAG_KEY_PARTITION = "partition";
    public static final String TAG_KEY_STATUS = "status";
    public static final String TAG_KEY_ORGANIZATIONID = "organizationId";
    public static final String TAG_VALUE_PROCESSINSTANCES = "processInstances";
    public static final String TAG_VALUE_CORESTATISTICS = "corestatistics";
    public static final String TAG_VALUE_SUCCEEDED = "succeeded";
    public static final String TAG_VALUE_FAILED = "failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private Timer importBatchTimer;
    @Autowired
    private MeterRegistry registry;

    public void recordCounts(String name, long count, String ... tags) {
        this.registry.counter(OPERATE_NAMESPACE + name, tags).increment((double)count);
    }

    public <T> void registerGauge(String name, T stateObject, ToDoubleFunction<T> valueFunction, String ... tags) {
        Gauge.builder((String)name, stateObject, valueFunction).tags(tags).register(this.registry);
    }

    public void registerGaugeSupplier(String name, Supplier<Number> gaugeSupplier, String ... tags) {
        Gauge.builder((String)name, gaugeSupplier).tags(tags).register(this.registry);
    }

    public void registerGaugeSupplier(String name, String description, Supplier<Number> gaugeSupplier, String ... tags) {
        Gauge.builder((String)name, gaugeSupplier).tags(tags).description(description).register(this.registry);
    }

    public <E> void registerGaugeQueueSize(String name, Queue<E> queue, String ... tags) {
        this.registerGauge(name, queue, q -> q.size(), tags);
    }

    public Timer getTimer(String name, String ... tags) {
        return this.registry.timer(name, tags);
    }

    public MeterRegistry getMeterRegistry() {
        return this.registry;
    }

    public Timer getHistogram(String name, String ... tags) {
        return Timer.builder((String)name).publishPercentileHistogram().tags(tags).register(this.registry);
    }
}

