/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.starter;

import io.camunda.identity.starter.LogoutListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnBean(value={LogoutListener.class})
@RestController
@RequestMapping(value={"/identity-auth"})
public class IdentityCallbackController {
    private final LogoutListener logoutListener;

    public IdentityCallbackController(LogoutListener logoutListener) {
        this.logoutListener = logoutListener;
    }

    @GetMapping(value={"/logout-callback"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void logoutCallback(@RequestParam(value="sid", required=false) String sid, @RequestParam(value="iss", required=false) String iss, HttpServletRequest request, HttpServletResponse response) {
        this.logoutListener.onLogout(sid, iss, request, response);
    }
}

