/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.starter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public interface LogoutListener {

  /**
   * Handle logout
   *
   * @param sid      the oidc session id
   * @param iss      the oidc token issuer
   * @param request  the instance of request
   * @param response the instance of response
   */
  void onLogout(final String sid, final String iss,
                final HttpServletRequest request,
                final HttpServletResponse response);
}
