/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl.http;

import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.ElementTemplate;
import io.camunda.connector.generator.dsl.ElementTemplateBuilder;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.dsl.http.HttpAuthentication;
import io.camunda.connector.generator.dsl.http.HttpOperation;
import io.camunda.connector.generator.dsl.http.HttpServerData;
import io.camunda.connector.generator.dsl.http.PropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class HttpOutboundElementTemplateBuilder {
    private static final String CONNECTOR_TYPE = "io.camunda:http-json:1";
    private final ElementTemplateBuilder builder;
    private Collection<HttpServerData> servers;
    private Collection<HttpOperation> operations;
    private List<HttpAuthentication> authentication = List.of(HttpAuthentication.NoAuth.INSTANCE);

    private HttpOutboundElementTemplateBuilder(boolean configurable) {
        this.builder = ElementTemplateBuilder.createOutbound().type(CONNECTOR_TYPE, configurable).icon(ElementTemplateIcon.from((String)"rest-connector-icon.svg", (ClassLoader)this.getClass().getClassLoader()));
    }

    public static HttpOutboundElementTemplateBuilder create() {
        return new HttpOutboundElementTemplateBuilder(false);
    }

    public static HttpOutboundElementTemplateBuilder create(boolean configurable) {
        return new HttpOutboundElementTemplateBuilder(configurable);
    }

    public HttpOutboundElementTemplateBuilder id(String id) {
        this.builder.id(id);
        return this;
    }

    public HttpOutboundElementTemplateBuilder name(String name) {
        this.builder.name(name);
        return this;
    }

    public HttpOutboundElementTemplateBuilder version(int version) {
        this.builder.version(version);
        return this;
    }

    public HttpOutboundElementTemplateBuilder icon(ElementTemplateIcon icon) {
        this.builder.icon(icon);
        return this;
    }

    public HttpOutboundElementTemplateBuilder documentationRef(String documentationRef) {
        this.builder.documentationRef(documentationRef);
        return this;
    }

    public HttpOutboundElementTemplateBuilder description(String description) {
        this.builder.description(description);
        return this;
    }

    public HttpOutboundElementTemplateBuilder servers(Collection<HttpServerData> servers) {
        this.servers = new ArrayList<HttpServerData>(servers);
        return this;
    }

    public HttpOutboundElementTemplateBuilder servers(HttpServerData ... servers) {
        return this.servers(Arrays.asList(servers));
    }

    public HttpOutboundElementTemplateBuilder operations(Collection<HttpOperation> operations) {
        if (this.operations != null && !this.operations.isEmpty()) {
            throw new IllegalStateException("Operations are already set: " + String.valueOf(operations));
        }
        this.operations = new ArrayList<HttpOperation>(operations);
        return this;
    }

    public HttpOutboundElementTemplateBuilder operations(HttpOperation ... operations) {
        return this.operations(Arrays.asList(operations));
    }

    public HttpOutboundElementTemplateBuilder operation(HttpOperation operation) {
        if (this.operations == null) {
            this.operations = new ArrayList<HttpOperation>();
        }
        this.operations.add(operation);
        return this;
    }

    public HttpOutboundElementTemplateBuilder authentication(List<HttpAuthentication> authentication) {
        this.authentication = authentication;
        return this;
    }

    public HttpOutboundElementTemplateBuilder elementType(GeneratorConfiguration.ConnectorElementType elementType) {
        this.builder.elementType(elementType.elementType());
        this.builder.appliesTo(elementType.appliesTo());
        return this;
    }

    public ElementTemplate build() {
        if (this.operations == null || this.operations.isEmpty()) {
            throw new IllegalStateException("Could not find any supported operations");
        }
        return this.builder.propertyGroups(List.of(PropertyUtil.serverDiscriminatorPropertyGroup(this.servers), PropertyUtil.operationDiscriminatorPropertyGroup(this.operations), PropertyUtil.authPropertyGroup(this.authentication, this.operations), PropertyUtil.parametersPropertyGroup(this.operations), PropertyUtil.requestBodyPropertyGroup(this.operations), PropertyUtil.urlPropertyGroup(), PropertyGroup.OUTPUT_GROUP_OUTBOUND, PropertyGroup.ERROR_GROUP, PropertyGroup.RETRIES_GROUP)).build();
    }
}

