/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl.http;

import io.camunda.connector.generator.dsl.http.HttpAuthentication;
import io.camunda.connector.generator.dsl.http.HttpFeelBuilder;
import io.camunda.connector.generator.dsl.http.HttpOperation;
import io.camunda.connector.generator.dsl.http.HttpOperationProperty;
import io.camunda.connector.http.base.model.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class HttpOperationBuilder {
    private String id;
    private String label;
    private HttpMethod method;
    private HttpFeelBuilder pathFeelExpression;
    private HttpFeelBuilder bodyFeelExpression;
    private List<HttpAuthentication> authenticationOverride = null;
    private List<HttpOperationProperty> properties = Collections.emptyList();

    public static HttpOperationBuilder create() {
        return new HttpOperationBuilder();
    }

    public static HttpOperationBuilder createForUpdate(HttpOperation operation) {
        return new HttpOperationBuilder().id(operation.id()).label(operation.label()).method(operation.method()).pathFeelExpression(operation.pathFeelExpression()).bodyFeelExpression(operation.bodyFeelExpression()).authenticationOverride(operation.authenticationOverride()).properties(operation.properties());
    }

    public HttpOperationBuilder id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public HttpOperationBuilder label(String label) {
        this.label = label;
        return this;
    }

    public HttpOperationBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpOperationBuilder pathFeelExpression(HttpFeelBuilder builder) {
        this.pathFeelExpression = builder;
        return this;
    }

    public HttpOperationBuilder bodyFeelExpression(HttpFeelBuilder bodyFeelExpression) {
        this.bodyFeelExpression = bodyFeelExpression;
        return this;
    }

    public HttpOperationBuilder authenticationOverride(List<HttpAuthentication> authentication) {
        this.authenticationOverride = authentication;
        return this;
    }

    public HttpOperationBuilder properties(HttpOperationProperty ... properties) {
        return this.properties(Arrays.asList(properties));
    }

    public HttpOperationBuilder properties(Collection<HttpOperationProperty> properties) {
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new IllegalStateException("Properties already set");
        }
        this.properties = new ArrayList<HttpOperationProperty>(properties);
        return this;
    }

    public List<HttpOperationProperty> getProperties() {
        return this.properties;
    }

    public HttpOperation build() {
        this.validate();
        ArrayList transformedProperties = new ArrayList();
        HashSet<String> headerProperties = new HashSet<String>();
        HashSet<String> queryParamProperties = new HashSet<String>();
        for (HttpOperationProperty property : this.properties) {
            if (property.target() == HttpOperationProperty.Target.HEADER) {
                headerProperties.add(property.id());
                continue;
            }
            if (property.target() != HttpOperationProperty.Target.QUERY) continue;
            queryParamProperties.add(property.id());
        }
        return new HttpOperation(this.id, this.label, this.pathFeelExpression, this.method, this.bodyFeelExpression, this.properties, this.authenticationOverride);
    }

    private void validate() {
        if (this.method == null) {
            throw new IllegalStateException("HTTP method is not defined");
        }
        if (this.id == null) {
            throw new IllegalStateException("Operation id is not defined");
        }
        if (this.label == null) {
            throw new IllegalStateException("Operation description is not defined");
        }
    }

    public String toString() {
        return "HttpOperationBuilder{id='" + this.id + "', label='" + this.label + "', method=" + String.valueOf(this.method) + ", pathFeelExpression=" + String.valueOf(this.pathFeelExpression) + ", bodyFeelExpression=" + String.valueOf(this.bodyFeelExpression) + ", authenticationOverride=" + String.valueOf(this.authenticationOverride) + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

