/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl.http;

import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.dsl.StringProperty;
import io.camunda.connector.generator.dsl.http.HttpAuthentication;
import io.camunda.connector.generator.dsl.http.HttpFeelBuilder;
import io.camunda.connector.generator.dsl.http.HttpOperation;
import io.camunda.connector.generator.dsl.http.HttpOperationProperty;
import io.camunda.connector.generator.dsl.http.HttpServerData;
import io.camunda.connector.generator.java.util.TemplatePropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyUtil {
    static final String OPERATION_DISCRIMINATOR_PROPERTY_ID = "operationId";
    static final String AUTH_DISCRIMINATOR_PROPERTY_ID = "authType";
    static final String OPERATION_PATH_INPUT_NAME = "operationPath";

    static PropertyBuilder authDiscriminatorPropertyPrefab(Collection<HttpAuthentication> availableTypes) {
        if (availableTypes.isEmpty()) {
            throw new RuntimeException("No auth types, expected at least one");
        }
        List<DropdownProperty.DropdownChoice> choices = availableTypes.stream().map(type -> new DropdownProperty.DropdownChoice(type.label(), type.id())).toList();
        return DropdownProperty.builder().choices(choices).id(AUTH_DISCRIMINATOR_PROPERTY_ID).group("authentication").label("Authentication").optional(false).binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")).value(choices.getFirst().value());
    }

    static PropertyGroup operationDiscriminatorPropertyGroup(Collection<HttpOperation> operations) {
        if (operations.size() == 1) {
            return PropertyGroup.builder().id("operation").label("Operation").properties(new PropertyBuilder[]{HiddenProperty.builder().id(OPERATION_DISCRIMINATOR_PROPERTY_ID).value(operations.iterator().next().id()).binding((PropertyBinding)new PropertyBinding.ZeebeInput(OPERATION_DISCRIMINATOR_PROPERTY_ID))}).build();
        }
        return PropertyGroup.builder().id("operation").label("Operation").properties(new Property[]{DropdownProperty.builder().choices(operations.stream().map(operation -> new DropdownProperty.DropdownChoice(operation.label(), operation.id())).collect(Collectors.toList())).id(OPERATION_DISCRIMINATOR_PROPERTY_ID).group("operation").value(operations.iterator().next().id()).binding((PropertyBinding)new PropertyBinding.ZeebeInput(OPERATION_DISCRIMINATOR_PROPERTY_ID)).build()}).build();
    }

    static PropertyGroup serverDiscriminatorPropertyGroup(Collection<HttpServerData> servers) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (servers == null || servers.isEmpty()) {
            properties.add(StringProperty.builder().id("baseUrl").group("server").label("Base URL").binding((PropertyBinding)new PropertyBinding.ZeebeInput("baseUrl")).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).build());
        } else if (servers.size() == 1) {
            properties.add(HiddenProperty.builder().id("baseUrl").group("server").value(servers.iterator().next().baseUrl()).binding((PropertyBinding)new PropertyBinding.ZeebeInput("baseUrl")).build());
        } else {
            properties.add(DropdownProperty.builder().choices(servers.stream().map(server -> new DropdownProperty.DropdownChoice(server.label(), server.baseUrl())).collect(Collectors.toList())).id("baseUrl").value(servers.iterator().next().baseUrl()).label("Server").group("server").binding((PropertyBinding)new PropertyBinding.ZeebeInput("baseUrl")).build());
        }
        return PropertyGroup.builder().id("server").label("Server").properties(properties).build();
    }

    static PropertyGroup authPropertyGroup(Collection<HttpAuthentication> authentications, Collection<HttpOperation> operations) {
        List<String> operationsWithoutCustomAuth = operations.stream().filter(op -> op.authenticationOverride() == null || op.authenticationOverride().isEmpty()).map(HttpOperation::id).toList();
        ArrayList<Property> properties = new ArrayList<Property>();
        if (authentications.size() > 1) {
            Property discriminator = PropertyUtil.authDiscriminatorPropertyPrefab(authentications).condition((PropertyCondition)new PropertyCondition.OneOf(OPERATION_DISCRIMINATOR_PROPERTY_ID, operationsWithoutCustomAuth)).build();
            properties.add(discriminator);
        } else if (!authentications.isEmpty()) {
            properties.add(HiddenProperty.builder().id(AUTH_DISCRIMINATOR_PROPERTY_ID).group("authentication").value(authentications.iterator().next().id()).binding((PropertyBinding)new PropertyBinding.ZeebeInput(AUTH_DISCRIMINATOR_PROPERTY_ID)).condition((PropertyCondition)new PropertyCondition.OneOf(OPERATION_DISCRIMINATOR_PROPERTY_ID, operationsWithoutCustomAuth)).build());
        }
        for (HttpAuthentication authentication : authentications) {
            List<Property> authProperties = HttpAuthentication.getPropertyPrefabs(authentication).stream().map(builder -> builder.condition((PropertyCondition)new PropertyCondition.AllMatch(new PropertyCondition[]{new PropertyCondition.Equals(AUTH_DISCRIMINATOR_PROPERTY_ID, authentication.id()), new PropertyCondition.OneOf(OPERATION_DISCRIMINATOR_PROPERTY_ID, operationsWithoutCustomAuth)})).build()).toList();
            properties.addAll(authProperties);
        }
        for (HttpOperation operation : operations) {
            boolean addedDiscriminator;
            if (operation.authenticationOverride() == null) continue;
            String authDiscriminator = operation.id() + "_authType";
            if (operation.authenticationOverride().size() > 1) {
                addedDiscriminator = true;
                properties.add(PropertyUtil.authDiscriminatorPropertyPrefab(operation.authenticationOverride()).id(authDiscriminator).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).build());
            } else {
                addedDiscriminator = false;
            }
            for (HttpAuthentication authentication : operation.authenticationOverride()) {
                List<Property> authProperties = HttpAuthentication.getPropertyPrefabs(authentication).stream().map(builder -> {
                    builder.id(operation.id() + "_" + builder.getId());
                    if (addedDiscriminator) {
                        builder.condition((PropertyCondition)new PropertyCondition.AllMatch(new PropertyCondition[]{new PropertyCondition.Equals(authDiscriminator, authentication.id()), new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())}));
                    } else {
                        builder.condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id()));
                    }
                    return builder.build();
                }).toList();
                properties.addAll(authProperties);
            }
        }
        return PropertyGroup.builder().id("authentication").label("Authentication").properties(properties).build();
    }

    static PropertyGroup parametersPropertyGroup(Collection<HttpOperation> operations) {
        ArrayList properties = new ArrayList();
        for (HttpOperation operation : operations) {
            HashSet<String> headerProperties = new HashSet<String>();
            HashSet<String> queryProperties = new HashSet<String>();
            ArrayList<Property> transformedProperties = new ArrayList<Property>();
            for (HttpOperationProperty property : operation.properties()) {
                if (property.target() == HttpOperationProperty.Target.BODY) continue;
                Property transformed = PropertyUtil.transformProperty(operation.id(), property, "parameters");
                PropertyBinding propertyBinding = transformed.getBinding();
                if (!(propertyBinding instanceof PropertyBinding.ZeebeInput)) {
                    throw new RuntimeException("Unexpected binding type: " + String.valueOf(transformed.getBinding().getClass()));
                }
                PropertyBinding.ZeebeInput binding = (PropertyBinding.ZeebeInput)propertyBinding;
                if (property.target() == HttpOperationProperty.Target.HEADER) {
                    headerProperties.add(binding.name());
                } else if (property.target() == HttpOperationProperty.Target.QUERY) {
                    queryProperties.add(binding.name());
                }
                transformedProperties.add(transformed);
            }
            Property operationPathProperty = HiddenProperty.builder().id(operation.id() + "_$path").group("parameters").binding((PropertyBinding)new PropertyBinding.ZeebeInput(OPERATION_PATH_INPUT_NAME)).value(operation.pathFeelExpression().build()).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).build();
            Property operationHeadersProperty = HiddenProperty.builder().id(operation.id() + "_$headers").group("parameters").value(PropertyUtil.buildContextExpression(headerProperties)).binding((PropertyBinding)new PropertyBinding.ZeebeInput("headers")).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).build();
            Property operationQueryProperty = HiddenProperty.builder().id(operation.id() + "_$queryParameters").group("parameters").value(PropertyUtil.buildContextExpression(queryProperties)).binding((PropertyBinding)new PropertyBinding.ZeebeInput("queryParameters")).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).build();
            Property operationMethodProperty = HiddenProperty.builder().id(operation.id() + "_$method").group("parameters").value(operation.method().name()).binding((PropertyBinding)new PropertyBinding.ZeebeInput("method")).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).build();
            properties.addAll(transformedProperties);
            properties.add(operationPathProperty);
            properties.add(operationHeadersProperty);
            properties.add(operationQueryProperty);
            properties.add(operationMethodProperty);
        }
        return PropertyGroup.builder().id("parameters").label("Parameters").properties(properties).build();
    }

    private static Property transformProperty(String operationId, HttpOperationProperty property, String group) {
        PropertyBuilder builder = switch (property.type()) {
            default -> throw new MatchException(null, null);
            case HttpOperationProperty.Type.STRING -> StringProperty.builder().value(property.example()).feel(Property.FeelMode.optional);
            case HttpOperationProperty.Type.ENUM -> DropdownProperty.builder().choices(property.choices().stream().map(choice -> new DropdownProperty.DropdownChoice(choice, choice)).toList());
            case HttpOperationProperty.Type.FEEL -> StringProperty.builder().value(property.example()).feel(Property.FeelMode.required);
        };
        builder.id(operationId + "_" + property.target().name().toLowerCase() + "_" + property.id()).label(TemplatePropertiesUtil.transformIdIntoLabel((String)property.id())).description(property.description()).optional(!property.required()).binding((PropertyBinding)new PropertyBinding.ZeebeInput(property.id())).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operationId)).group(group);
        if (property.required()) {
            builder.constraints(PropertyConstraints.builder().notEmpty(true).build());
        }
        return builder.build();
    }

    static PropertyGroup requestBodyPropertyGroup(Collection<HttpOperation> operations) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (HttpOperation operation : operations) {
            if (!operation.method().supportsBody) continue;
            List<Property> bodyProperties = operation.properties().stream().filter(p -> p.target() == HttpOperationProperty.Target.BODY).map(p -> PropertyUtil.transformProperty(operation.id(), p, "requestBody")).toList();
            Property bodyAggregationProperty = bodyProperties.isEmpty() ? StringProperty.builder().id(operation.id() + "_body").feel(Property.FeelMode.required).group("requestBody").value(Optional.ofNullable(operation.bodyFeelExpression()).map(HttpFeelBuilder::build).orElse("")).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).binding((PropertyBinding)new PropertyBinding.ZeebeInput("body")).build() : HiddenProperty.builder().id(operation.id() + "_$body").group("requestBody").value(Optional.ofNullable(operation.bodyFeelExpression()).map(HttpFeelBuilder::build).orElse("")).condition((PropertyCondition)new PropertyCondition.Equals(OPERATION_DISCRIMINATOR_PROPERTY_ID, operation.id())).binding((PropertyBinding)new PropertyBinding.ZeebeInput("body")).build();
            properties.addAll(bodyProperties);
            properties.add(bodyAggregationProperty);
        }
        return PropertyGroup.builder().id("requestBody").label("Request body").properties(properties).build();
    }

    static PropertyGroup urlPropertyGroup() {
        Property urlProperty = HiddenProperty.builder().id("url").binding((PropertyBinding)new PropertyBinding.ZeebeInput("url")).group("url").value("= baseUrl + operationPath").build();
        return PropertyGroup.builder().id("url").label("URL").properties(new Property[]{urlProperty}).build();
    }

    private static String buildContextExpression(Set<String> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append("={");
        Iterator<String> it = properties.iterator();
        while (it.hasNext()) {
            String prop = it.next();
            sb.append(prop).append(": ").append(prop);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

