/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl.http;

import io.camunda.connector.feel.FeelEngineWrapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class HttpFeelBuilder {
    protected StringBuilder sb = new StringBuilder();
    protected final Set<String> propertySet = new HashSet<String>();
    private static final FeelEngineWrapper feelEngineWrapper = new FeelEngineWrapper();
    public static final String FEEL_OPERATOR_CHARACTERS = "!=<>+-*/[]{}@ ";

    public static HttpFeelStringBuilder string() {
        return new HttpFeelStringBuilder();
    }

    public static HttpFeelContextBuilder context() {
        return new HttpFeelContextBuilder();
    }

    public static HttpFeelBuilder preFormatted(final String preFormatted) {
        return new HttpFeelBuilder(){

            @Override
            public String build() {
                return preFormatted;
            }
        };
    }

    public String build() {
        String result = this.sb.toString();
        HttpFeelBuilder.evaluateFeel(result, this.propertySet);
        return result;
    }

    static void evaluateFeel(String expression, Set<String> propertyList) {
        Map<String, String> mockPropertyContext = propertyList.stream().collect(Collectors.toMap(property -> property, property -> "mock"));
        feelEngineWrapper.evaluate(expression, new Object[]{mockPropertyContext});
    }

    public static class HttpFeelStringBuilder
    extends HttpFeelBuilder {
        public HttpFeelStringBuilder part(String part) {
            if (this.sb.isEmpty()) {
                this.sb.append("=");
            } else {
                this.sb.append("+");
            }
            this.sb.append("\"");
            this.sb.append(part);
            this.sb.append("\"");
            return this;
        }

        public HttpFeelStringBuilder property(String property) {
            if (property == null || property.isEmpty()) {
                throw new IllegalArgumentException("Property must not be null or empty");
            }
            for (char c : HttpFeelBuilder.FEEL_OPERATOR_CHARACTERS.toCharArray()) {
                if (!property.contains(String.valueOf(c))) continue;
                throw new IllegalArgumentException("Property must not contain FEEL operator characters: !=<>+-*/[]{}@ ");
            }
            if (this.sb.isEmpty()) {
                this.sb.append("=");
            } else {
                this.sb.append("+");
            }
            this.sb.append(property);
            this.propertySet.add(property);
            return this;
        }

        public HttpFeelStringBuilder slash() {
            if (this.sb.isEmpty()) {
                this.sb.append("=");
            } else {
                this.sb.append("+");
            }
            this.sb.append("\"/\"");
            return this;
        }
    }

    public static class HttpFeelContextBuilder
    extends HttpFeelBuilder {
        StringBuilder feelContextSb = new StringBuilder();

        public HttpFeelContextBuilder property(String targetName, String propertySourceName) {
            if (this.feelContextSb.isEmpty()) {
                this.feelContextSb.append("={");
            } else {
                this.feelContextSb.append(",");
            }
            this.feelContextSb.append(targetName);
            this.feelContextSb.append(":");
            this.feelContextSb.append(propertySourceName);
            this.propertySet.add(propertySourceName);
            return this;
        }

        @Override
        public String build() {
            this.sb = new StringBuilder(this.feelContextSb.toString());
            this.sb.append("}");
            return super.build();
        }
    }
}

